;----------------------------------------------------------------------
; Dirk Grossmann's Emacs site initialization file
; Should only contain options that are applicable with both X and
; terminal sessions.
;======================================================================

; Make searches case-INsensitive.
(set-default 'case-fold-search t)

; Display date and time in the border bar.
(setq display-time-24hr-format t)
(setq make-backup-files nil)
(display-time)

; Display ISO Latin 1 characters.
(standard-display-european 1)

; Enable Font Lock for all modes.
(cond ((fboundp 'global-font-lock-mode)
       ;; Load the font-lock package.
       (require 'font-lock)
       ;; Maximum colors.
       (setq font-lock-maximum-decoration t)
       ;; Turn on font-lock in all modes that support it.
       (global-font-lock-mode t)))

; Additional Major Modes.
(setq auto-mode-alist (cons '("\\.idl\\'"  . c++-mode)  auto-mode-alist))
(setq auto-mode-alist (cons '("\\.odl\\'"  . c++-mode)  auto-mode-alist))
(setq auto-mode-alist (cons '("\\.rc\\'"   . c++-mode)  auto-mode-alist))
(setq auto-mode-alist (cons '("\\.asp\\'"  . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.jsp\\'"  . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.htx\\'"  . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.tmpl\\'" . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.js\\'"   . java-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.mki\\'"  . makefile-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.pl\\'"   . perl-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.properties\\'" . makefile-mode) auto-mode-alist))
