/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.webexport.ImageMagickExporter;
import java.io.File;

public class FileObject
extends AbstractFSObject {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_IMAGE_PREVIEW = 1;
    public static final int TYPE_IMAGE = 2;
    public static final int TYPE_HTML_DOC = 3;
    public static final int TYPE_XML_DOC = 4;
    public static final int TYPE_PDF_DOC = 5;
    public static final int TYPE_MSWORD_DOC = 6;
    public static final int TYPE_MSVISIO_DOC = 7;
    public static final int TYPE_TEXT_DOC = 8;
    public static final int TYPE_CAD_DOC = 9;
    public static final int TYPE_ZIP_DOC = 10;
    public static final int TYPE_REFERENCE = 11;
    public static final int TYPE_HTML_REF = 12;
    public static final int TYPE_SEPARATOR = 13;
    public static final String SEPARATOR = "separator:";

    public FileObject(String name, DirectoryObject parentDir) {
        super(parentDir);
        this.setFileName(name, false);
        this.m_isReference = this.m_fileName.length() == 0;
    }

    public void setPropertiesFromImageMetadata() {
    }

    @Override
    public boolean isEmpty() {
        if (this.isSeparator()) {
            return false;
        }
        return super.isEmpty();
    }

    public boolean isSeparator() {
        if (this.m_fileNamePart.length() == 0) {
            return false;
        }
        return this.m_fileNamePart.equalsIgnoreCase(SEPARATOR);
    }

    public void makeSeparator() {
        this.setFileNamePart(SEPARATOR);
        this.m_properties.put("href", "");
        this.setFileName("", false);
        this.m_isReference = true;
    }

    public String getBaseFileName() {
        String name = this.getFileName();
        int i = name.indexOf(46);
        if (i >= 0) {
            return name.substring(0, i);
        }
        return name;
    }

    public int getFileType() {
        if (this.isSeparator()) {
            return 13;
        }
        if (this.isReference()) {
            String str = this.get("href");
            if (str != null && ((str = str.toLowerCase().trim()).startsWith("http:") || str.startsWith("ftp:"))) {
                return 12;
            }
            return 11;
        }
        String str = this.getFileName().toLowerCase();
        if (str.endsWith("gif") || str.endsWith("jpg") || str.endsWith("jpeg") || str.endsWith("png")) {
            return 1;
        }
        if (str.endsWith("tif") || str.endsWith("tiff")) {
            return ImageMagickExporter.isImageMagickAvailable() ? 1 : 2;
        }
        if (str.endsWith("psd") || str.endsWith("xcf") || str.endsWith("bmp") || str.endsWith("pcx")) {
            return 2;
        }
        if (str.endsWith("htm") || str.endsWith("html")) {
            return 3;
        }
        if (str.endsWith("xml") || str.endsWith("dtd") || str.endsWith("xsd")) {
            return 4;
        }
        if (str.endsWith("pdf")) {
            return 5;
        }
        if (str.endsWith("doc")) {
            return 6;
        }
        if (str.endsWith("vsd")) {
            return 7;
        }
        if (str.endsWith("txt") || str.endsWith("text") || str.endsWith("tex")) {
            return 8;
        }
        if (str.endsWith("dxf") || str.endsWith("dwg")) {
            return 9;
        }
        if (str.endsWith("zip") || str.endsWith("tar") || str.endsWith("gz") || str.endsWith("tgz")) {
            return 10;
        }
        return 0;
    }

    public boolean isImageMagickRequiredForDisplay() {
        String str = this.getFileName().toLowerCase();
        return str.endsWith("tif") || str.endsWith("tiff");
    }

    @Override
    public String getFileSizeStr(boolean bInKB) {
        long sz = new File(this.getFullPath()).length();
        if (bInKB && sz >= 1024L) {
            String s;
            int i;
            double szInKB = (double)sz / 1024.0;
            String suff = " KB";
            int prec = 2;
            if (szInKB > 1024.0) {
                szInKB /= 1024.0;
                suff = " MB";
                prec = 3;
            }
            if ((i = (s = Double.toString(szInKB)).indexOf(46)) > 0 && i + prec < s.length()) {
                s = s.substring(0, i + prec);
            }
            if (s.endsWith(".0") || s.endsWith(".00")) {
                s = s.substring(0, i);
            }
            return s + suff;
        }
        return Long.toString(sz) + " Bytes";
    }

    @Override
    public String toString() {
        if (this.isSeparator()) {
            return "-------";
        }
        return super.toString();
    }
}

