/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.persist.PersistException;
import com.dgrossmann.photo.dir.persist.PersistFactory;
import com.dgrossmann.photo.settings.Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SeriesContainer {
    private Settings m_settings;
    private List<String> m_seriesContainerNames;
    private List<DirectoryObject> m_seriesDirectories;
    private List<DirectoryObject> m_loadedSeriesDirectories;

    public SeriesContainer(Settings settings) {
        this.m_settings = settings;
        this.m_seriesContainerNames = new ArrayList<String>(25);
        this.m_seriesDirectories = new ArrayList<DirectoryObject>(25);
        this.m_loadedSeriesDirectories = new ArrayList<DirectoryObject>(25);
        try {
            Iterator<String> iter = this.m_settings.getSeriesContainerNameIterator();
            while (iter.hasNext()) {
                this.addSeriesContainer(iter.next());
            }
        }
        catch (PersistException persistException) {
            // empty catch block
        }
    }

    public void clearSeriesContainers() {
        this.m_seriesContainerNames.clear();
        this.m_seriesDirectories.clear();
        this.m_loadedSeriesDirectories.clear();
    }

    public boolean hasSeriesDirectories() {
        return this.m_seriesDirectories.size() > 0;
    }

    public boolean isSeriesDirectory(DirectoryObject dirObj) {
        return this.m_seriesDirectories.contains(dirObj);
    }

    private void getSeriesFromContainer(String containerDirName) throws PersistException {
        File dir = new File(containerDirName);
        String[] dirNames = dir.list();
        if (dirNames == null) {
            return;
        }
        for (int i = 0; i < dirNames.length; ++i) {
            File f;
            String str = dirNames[i].toLowerCase();
            if (str.startsWith(".") || str.startsWith("_") || str.startsWith("x_") || str.startsWith("x-") || !(f = new File(dir, dirNames[i])).isDirectory()) continue;
            DirectoryObject de = new DirectoryObject(f.getAbsolutePath(), null);
            this.m_seriesDirectories.add(de);
        }
    }

    public void mergeSeriesContainers(List<String> seriesContainerNames) throws PersistException {
        ArrayList<String> toDelete = new ArrayList<String>(this.m_seriesContainerNames.size());
        for (String name : this.m_seriesContainerNames) {
            if (seriesContainerNames.contains(name)) continue;
            toDelete.add(name);
        }
        this.m_seriesContainerNames.removeAll(toDelete);
        for (String name : seriesContainerNames) {
            if (this.m_seriesContainerNames.contains(name)) continue;
            this.addSeriesContainer(name);
        }
    }

    public void addSeriesContainer(String containerDirName) throws PersistException {
        File dir = new File(containerDirName);
        if (!dir.isDirectory()) {
            throw new PersistException(5, (Object)containerDirName, null, "Not a directory");
        }
        this.m_seriesContainerNames.add(containerDirName);
        this.getSeriesFromContainer(containerDirName);
    }

    public void ensureLoaded(DirectoryObject seriesDir) {
        if (this.m_loadedSeriesDirectories.contains(seriesDir)) {
            return;
        }
        try {
            this.loadSeries(seriesDir);
        }
        catch (Exception e) {
            return;
        }
        this.m_loadedSeriesDirectories.add(seriesDir);
    }

    public void refresh() throws PersistException {
        this.m_seriesDirectories.clear();
        this.m_loadedSeriesDirectories.clear();
        Iterator<String> iter = this.m_seriesContainerNames.iterator();
        while (iter.hasNext()) {
            this.getSeriesFromContainer(iter.next());
        }
    }

    public String getRelativePath(String from, String to) {
        int i;
        if (File.separatorChar != '\\') {
            from = from.replace('\\', File.separatorChar);
            to = to.replace('\\', File.separatorChar);
        }
        if (File.separatorChar != '/') {
            from = from.replace('/', File.separatorChar);
            to = to.replace('/', File.separatorChar);
        }
        for (i = 0; i < from.length() && i < to.length() && Character.toLowerCase(from.charAt(i)) == Character.toLowerCase(to.charAt(i)); ++i) {
        }
        if (i >= from.length()) {
            if (i >= to.length()) {
                return "";
            }
            if (to.charAt(i) == File.separatorChar) {
                return to.substring(i + 1);
            }
            --i;
        }
        while (i >= 0 && from.charAt(i) != File.separatorChar) {
            --i;
        }
        if (i <= 0) {
            return null;
        }
        StringTokenizer fromDiff = new StringTokenizer(from.substring(++i), File.separator);
        int numDiffFrom = fromDiff.countTokens();
        if (!new File(from).isDirectory()) {
            --numDiffFrom;
        }
        String retPath = "";
        while (numDiffFrom > 0) {
            retPath = retPath + ".." + File.separatorChar;
            --numDiffFrom;
        }
        if (i >= to.length()) {
            if (retPath.length() > 0 && retPath.endsWith(File.separator)) {
                return retPath.substring(0, retPath.length() - 1);
            }
            return retPath;
        }
        return retPath + to.substring(i);
    }

    public String getTitle() {
        return this.m_settings.get("gallery.title");
    }

    public String getDescription(boolean bAsHTML, String pClass) {
        String desc = this.m_settings.get("gallery.description");
        if (desc.length() == 0) {
            return "";
        }
        if (bAsHTML) {
            pClass = pClass != null && pClass.length() > 0 ? " class=\"" + pClass + "\"" : "";
            desc = desc.replaceAll("\\n\\n+", "<p" + pClass + ">");
        }
        return desc;
    }

    public DirectoryObject[] getSeriesDirectories() {
        if (this.m_seriesDirectories.size() == 0) {
            return new DirectoryObject[0];
        }
        ArrayList<DirectoryObject> inv = new ArrayList<DirectoryObject>(10);
        for (DirectoryObject series : this.m_seriesDirectories) {
            File f = new File(series.getFullPath());
            if (f.isDirectory()) continue;
            inv.add(series);
        }
        Iterator<DirectoryObject> dirIter = inv.iterator();
        while (dirIter.hasNext()) {
            this.m_seriesDirectories.remove(dirIter.next());
        }
        DirectoryObject[] entries = new DirectoryObject[this.m_seriesDirectories.size()];
        int i = 0;
        dirIter = this.m_seriesDirectories.iterator();
        while (dirIter.hasNext()) {
            entries[i++] = dirIter.next();
        }
        return entries;
    }

    public void loadSeries(DirectoryObject dirObj) throws PersistException {
        while (dirObj.getParent() != null) {
            dirObj = (DirectoryObject)dirObj.getParent();
        }
        if (!this.isSeriesDirectory(dirObj)) {
            throw new PersistException(1, (Object)dirObj, null, "Not a series directory");
        }
        dirObj.clear();
        PersistFactory.getPersist(this.m_settings).load(dirObj);
    }

    public void saveSeries(DirectoryObject dirObj, boolean bForce) throws PersistException {
        while (dirObj.getParent() != null) {
            dirObj = (DirectoryObject)dirObj.getParent();
        }
        if (!this.isSeriesDirectory(dirObj)) {
            throw new PersistException(3, (Object)dirObj, null, "Not a series directory");
        }
        PersistFactory.getPersist(this.m_settings).save(dirObj, bForce);
    }

    public void saveSeriesForWeb(DirectoryObject dirObj) throws PersistException {
        while (dirObj.getParent() != null) {
            dirObj = (DirectoryObject)dirObj.getParent();
        }
        if (!this.isSeriesDirectory(dirObj)) {
            throw new PersistException(3, (Object)dirObj, null, "Not a series directory");
        }
        PersistFactory.getPersist(this.m_settings).saveForWeb(dirObj);
    }
}

