/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir.persist;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.dir.persist.FSObjectComparator;
import com.dgrossmann.photo.dir.persist.IDirPersist;
import com.dgrossmann.photo.dir.persist.PersistException;
import com.dgrossmann.photo.settings.Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public abstract class AbstractDirPersist
implements IDirPersist {
    private Settings m_settings;

    public AbstractDirPersist(Settings settings) {
        this.m_settings = settings;
    }

    protected Settings getSettings() {
        return this.m_settings;
    }

    protected abstract String getMetaDataStoreName(DirectoryObject var1, boolean var2);

    protected abstract void readMetaDataStore(DirectoryObject var1, String var2) throws PersistException;

    @Override
    public void load(DirectoryObject seriesDirObj) throws PersistException {
        File dirFile = new File(seriesDirObj.getFullPath());
        if (!dirFile.isDirectory()) {
            PersistException pe = new PersistException(1, (Object)seriesDirObj, "", "Series directory is not a directory");
            pe.log();
            throw pe;
        }
        seriesDirObj.clear();
        this.readMetaDataStore(seriesDirObj, this.getMetaDataStoreName(seriesDirObj, true));
        this.scanDirectory(seriesDirObj);
    }

    private void scanDirectory(DirectoryObject dirObj) {
        FileObject fileObj;
        DirectoryObject subDirObj;
        String name;
        ArrayList<File> dirObjects = new ArrayList<File>();
        ArrayList<File> fileObjects = new ArrayList<File>();
        String[] contents = new File(dirObj.getFullPath()).list();
        if (contents == null) {
            return;
        }
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i].startsWith(".") || contents[i].startsWith("_") || contents[i].startsWith("#") || contents[i].startsWith("~") || contents[i].equalsIgnoreCase("thumbs.db")) continue;
            File f = new File(dirObj.getFullPath() + File.separator + contents[i]);
            if (f.isDirectory()) {
                dirObjects.add(f);
                continue;
            }
            fileObjects.add(f);
        }
        Collections.sort(dirObjects, new FSObjectComparator());
        Collections.sort(fileObjects, new FSObjectComparator());
        Iterator fsFileIter = dirObjects.iterator();
        while (fsFileIter.hasNext()) {
            name = ((File)fsFileIter.next()).getName();
            subDirObj = this.incorporateSubDir(dirObj, name);
            if (subDirObj == null) {
                subDirObj = new DirectoryObject(name, dirObj);
                subDirObj.setReference(false);
                dirObj.addChild(subDirObj, -1);
            }
            this.scanDirectory(subDirObj);
        }
        fsFileIter = fileObjects.iterator();
        while (fsFileIter.hasNext()) {
            name = ((File)fsFileIter.next()).getName();
            if (this.incorporateFile(dirObj, name)) continue;
            fileObj = new FileObject(name, dirObj);
            fileObj.setPropertiesFromImageMetadata();
            fileObj.setReference(false);
            dirObj.addChild(fileObj, -1);
        }
        ArrayList<AbstractFSObject> emptyRefs = new ArrayList<AbstractFSObject>(dirObj.getFileCount());
        Iterator<FileObject> fileIter = dirObj.getFileIterator();
        while (fileIter.hasNext()) {
            fileObj = fileIter.next();
            if (!fileObj.isEmpty()) continue;
            emptyRefs.add(fileObj);
        }
        Iterator refIter = emptyRefs.iterator();
        while (refIter.hasNext()) {
            dirObj.removeFile((FileObject)refIter.next());
        }
        emptyRefs.clear();
        Iterator<DirectoryObject> dirIter = dirObj.getSubDirIterator();
        while (dirIter.hasNext()) {
            subDirObj = dirIter.next();
            if (!subDirObj.isEmpty()) continue;
            emptyRefs.add(subDirObj);
        }
        refIter = emptyRefs.iterator();
        while (refIter.hasNext()) {
            dirObj.removeSubDir((DirectoryObject)refIter.next());
        }
    }

    private DirectoryObject incorporateSubDir(DirectoryObject dirObj, String fileName) {
        Iterator<DirectoryObject> iter = dirObj.getSubDirIterator();
        while (iter.hasNext()) {
            String fnpart;
            DirectoryObject subDirObj = iter.next();
            if (subDirObj == null || (fnpart = subDirObj.getFileNamePart()).length() == 0 || !fnpart.equalsIgnoreCase(fileName)) continue;
            subDirObj.setFileName(fileName, false);
            subDirObj.setFileNamePart("");
            subDirObj.setReference(false);
            return subDirObj;
        }
        return null;
    }

    private boolean incorporateFile(DirectoryObject dirObj, String fileName) {
        String name = fileName.toLowerCase();
        Iterator<FileObject> fileIter = dirObj.getFileIterator();
        while (fileIter.hasNext()) {
            boolean bMatch;
            String fnpart;
            FileObject fileObj = fileIter.next();
            if (fileObj == null || (fnpart = fileObj.getFileNamePart()).length() == 0) continue;
            if ((fnpart = fnpart.toLowerCase()).endsWith(".")) {
                fnpart = fnpart.substring(0, fnpart.length() - 1);
            }
            boolean bl = bMatch = name.indexOf(fnpart) >= 0;
            if (bMatch) {
                int partLength = fnpart.length();
                boolean bl2 = bMatch = partLength == name.length() || name.charAt(partLength) == '.';
            }
            if (!bMatch) continue;
            fileObj.setFileName(fileName, false);
            fileObj.setFileNamePart("");
            fileObj.setReference(false);
            if (fileObj.getTitle(false).length() == 0) {
                fileObj.setPropertiesFromImageMetadata();
            }
            return true;
        }
        return false;
    }

    protected abstract void internalSave(DirectoryObject var1, String var2, boolean var3) throws PersistException;

    @Override
    public void save(DirectoryObject seriesDirObj, boolean bForce) throws PersistException {
        if (bForce || seriesDirObj.isChanged()) {
            this.internalSave(seriesDirObj, this.getMetaDataStoreName(seriesDirObj, true), false);
        }
    }

    @Override
    public void saveForWeb(DirectoryObject seriesDirObj) throws PersistException {
        File outDir = new File(this.getSettings().get("export.dir"));
        if (!outDir.isDirectory()) {
            throw new PersistException(3, (Object)seriesDirObj, null, "No Web export directory");
        }
        File dir = new File(outDir, seriesDirObj.getFileName().toLowerCase());
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
        String metaDataFile = outDir + File.separator + this.getMetaDataStoreName(seriesDirObj, false);
        this.internalSave(seriesDirObj, metaDataFile, true);
    }
}

