/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir.persist;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.persist.AbstractDirPersist;
import com.dgrossmann.photo.dir.persist.DirPersistFile;
import com.dgrossmann.photo.dir.persist.DirPersistXmlFile;
import com.dgrossmann.photo.dir.persist.IDirPersist;
import com.dgrossmann.photo.dir.persist.PersistException;
import com.dgrossmann.photo.settings.Settings;
import java.io.File;

public class DirPersistDecorator
implements IDirPersist {
    public static boolean s_bSaveAsXML = true;
    public static boolean s_bExportAsXML = true;
    public static String s_saveXmlEncoding = "ISO-8859-1";
    public static String s_exportXmlEncoding = "ISO-8859-1";
    private Settings m_settings;
    private AbstractDirPersist m_primaryPersister;
    private AbstractDirPersist m_primaryWebPersister;
    private AbstractDirPersist m_secondaryPersister;
    private AbstractDirPersist m_secondaryWebPersister;

    public static void loadSettings(Settings settings) {
        s_bSaveAsXML = settings.getBoolean("metadata.save.xml", true);
        s_bExportAsXML = settings.getBoolean("metadata.export.xml", true);
        String enc = settings.get("metadata.save.xml.encoding");
        s_saveXmlEncoding = enc.length() > 0 ? enc : "ISO-8859-1";
        enc = settings.get("metadata.export.xml.encoding");
        s_exportXmlEncoding = enc.length() > 0 ? enc : "ISO-8859-1";
    }

    public DirPersistDecorator(Settings settings) {
        this.m_settings = settings;
        DirPersistFile filePersister = new DirPersistFile(settings);
        DirPersistXmlFile xmlFilePersister = new DirPersistXmlFile(settings);
        xmlFilePersister.setEncodings(s_saveXmlEncoding, s_exportXmlEncoding);
        if (s_bSaveAsXML) {
            this.m_primaryPersister = xmlFilePersister;
            this.m_secondaryPersister = filePersister;
        } else {
            this.m_primaryPersister = filePersister;
            this.m_secondaryPersister = xmlFilePersister;
        }
        if (s_bExportAsXML) {
            this.m_primaryWebPersister = xmlFilePersister;
            this.m_secondaryWebPersister = filePersister;
        } else {
            this.m_primaryWebPersister = filePersister;
            this.m_secondaryWebPersister = xmlFilePersister;
        }
    }

    @Override
    public boolean canLoad(DirectoryObject seriesDirObj) {
        if (this.m_primaryPersister.canLoad(seriesDirObj)) {
            return true;
        }
        return this.m_secondaryPersister.canLoad(seriesDirObj);
    }

    @Override
    public void load(DirectoryObject seriesDirObj) throws PersistException {
        if (this.m_primaryPersister.canLoad(seriesDirObj)) {
            this.m_primaryPersister.load(seriesDirObj);
        } else {
            this.m_secondaryPersister.load(seriesDirObj);
        }
    }

    @Override
    public void save(DirectoryObject seriesDirObj, boolean bForce) throws PersistException {
        this.m_primaryPersister.save(seriesDirObj, bForce);
        File f = new File(this.m_secondaryPersister.getMetaDataStoreName(seriesDirObj, true));
        if (f.exists()) {
            f.delete();
        }
    }

    @Override
    public void saveForWeb(DirectoryObject seriesDirObj) throws PersistException {
        this.m_primaryWebPersister.saveForWeb(seriesDirObj);
        File f = new File(this.m_settings.get("export.dir"), this.m_secondaryWebPersister.getMetaDataStoreName(seriesDirObj, false));
        if (f.exists()) {
            f.delete();
        }
    }
}

