/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir.persist;

import com.dgrossmann.photo.AppInfo;
import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.dir.persist.AbstractDirPersist;
import com.dgrossmann.photo.dir.persist.NamedValue;
import com.dgrossmann.photo.dir.persist.PersistException;
import com.dgrossmann.photo.settings.Settings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;

public class DirPersistFile
extends AbstractDirPersist {
    private static final String FOR_WEB = "web";
    private static final String SERIES = "series";
    private static final String GROUP = "group";
    private static final String FILE = "file";
    private static final String TO_EXPORT = "to-export";
    private static final String EXPORT_QUALITY = "export-quality";
    private static final String END = "end";
    private static final String END_FILE = "end-file";
    private static final String END_DESCRIPTION = "end-description";

    public DirPersistFile(Settings settings) {
        super(settings);
    }

    @Override
    protected String getMetaDataStoreName(DirectoryObject seriesDirObj, boolean bAbsolute) {
        String name = seriesDirObj.getFileName().toLowerCase();
        name = '_' + name.replace(' ', '-') + "_metadata.txt";
        if (!bAbsolute) {
            return seriesDirObj.getFileName().toLowerCase() + File.separator + name;
        }
        return seriesDirObj.getFullPath() + File.separator + name;
    }

    @Override
    public boolean canLoad(DirectoryObject seriesDirObj) {
        String fileName = this.getMetaDataStoreName(seriesDirObj, true);
        return new File(fileName).exists();
    }

    @Override
    protected void readMetaDataStore(DirectoryObject seriesDirObj, String metaDataFileName) throws PersistException {
        block15: {
            File metaDataFile = new File(metaDataFileName);
            if (!metaDataFile.exists()) {
                return;
            }
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(metaDataFile));
                String line = "";
                NamedValue val = new NamedValue();
                line = this.readValue(val, in, line);
                if (val.name.equals(FOR_WEB)) {
                    PersistException pe = new PersistException(1, (Object)seriesDirObj, metaDataFile.getAbsolutePath(), "This is a metadata file for a Web directory and cannot be loaded as series directory");
                    pe.log();
                    throw pe;
                }
                if (!val.name.equals(SERIES)) {
                    PersistException pe = new PersistException(1, (Object)seriesDirObj, metaDataFile.getAbsolutePath(), "@series expected near line:\n" + line);
                    pe.log();
                    throw pe;
                }
                if (line == null) {
                    PersistException pe = new PersistException(1, (Object)seriesDirObj, metaDataFile.getAbsolutePath(), "Unexpected end-of-file after series begin");
                    pe.log();
                    throw pe;
                }
                line = this.readDescription(seriesDirObj, val.value, in, line);
                if (line != null) {
                    line = this.readGroup(seriesDirObj, in, line);
                    break block15;
                }
                PersistException pe = new PersistException(1, (Object)seriesDirObj, metaDataFile.getAbsolutePath(), "Unexpected end-of-file after series description");
                pe.log();
                throw pe;
            }
            catch (Exception e) {
                PersistException pe = new PersistException(1, (Object)seriesDirObj, metaDataFile.getAbsolutePath(), e);
                pe.log();
                throw pe;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ignored) {}
            }
        }
    }

    private String readGroup(DirectoryObject parentDirObj, BufferedReader in, String line) throws Exception {
        NamedValue val = new NamedValue();
        while (line != null) {
            line = this.readValue(val, in, line);
            if (val.name.equals(END)) {
                return line;
            }
            if (val.name.equals(FILE)) {
                FileObject fileObj = new FileObject("", parentDirObj);
                parentDirObj.addChild(fileObj, -1);
                line = this.readDescription(fileObj, val.value, in, line);
                continue;
            }
            if (val.name.equals(GROUP)) {
                DirectoryObject dirObj = new DirectoryObject("", parentDirObj);
                parentDirObj.addChild(dirObj, -1);
                line = this.readDescription(dirObj, val.value, in, line);
                line = this.readGroup(dirObj, in, line);
                continue;
            }
            throw new Exception("@file, @group or @end expected at (@" + val.name + ' ' + val.value + ") near line: " + line);
        }
        return null;
    }

    private String readDescription(AbstractFSObject fsObj, String fnPart, BufferedReader in, String line) throws Exception {
        NamedValue val = new NamedValue();
        fsObj.setFileNamePart(fnPart);
        while (line != null) {
            line = this.readValue(val, in, line);
            if (val.name.equals(END_DESCRIPTION) || val.name.equals(END_FILE)) {
                return line;
            }
            if (val.name.equals(TO_EXPORT)) {
                int ch = val.value.length() > 0 ? (int)val.value.charAt(0) : 102;
                fsObj.setToExport(ch == 116 || ch == 121 || ch == 49);
                continue;
            }
            if (val.name.equals(EXPORT_QUALITY)) {
                try {
                    int quality = Integer.parseInt(val.value);
                    fsObj.setConversionQuality(quality);
                }
                catch (Exception ignored) {}
                continue;
            }
            fsObj.set(val.name, val.value);
        }
        return null;
    }

    private String readValue(NamedValue val, BufferedReader in, String line) throws Exception {
        val.value = "";
        val.name = "";
        while (line.length() == 0 || line.charAt(0) != '@') {
            line = in.readLine();
            if (line == null) {
                return null;
            }
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || line.charAt(0) == '@') continue;
            throw new Exception("Unexpected line: " + line);
        }
        int i = (line = line.substring(1)).indexOf(32);
        if (i >= 0) {
            val.name = line.substring(0, i).toLowerCase();
            val.value = line.substring(i).trim();
        } else {
            val.name = line.trim().toLowerCase();
        }
        if (val.name.startsWith(END)) {
            val.value = "";
            return "";
        }
        while ((line = in.readLine()) != null) {
            if (line.trim().startsWith("@")) {
                return line.trim();
            }
            val.value = val.value + '\n' + line;
        }
        return null;
    }

    @Override
    protected void internalSave(DirectoryObject seriesDirObj, String metadataStoreName, boolean bForWeb) throws PersistException {
        File f = new File(metadataStoreName);
        PrintWriter out = null;
        if (seriesDirObj.isError()) {
            throw new PersistException(3, (Object)seriesDirObj, null, "Cannot be saved because loading failed");
        }
        try {
            out = new PrintWriter(new FileWriter(f));
            out.println("# J Photo-Explorer (Version " + AppInfo.getVersionString() + ") photo series metadata file.");
            if (bForWeb) {
                out.println("# Metadata exported for the Web. Do not load as regular series metadata.");
                out.println();
                this.writeValue(FOR_WEB, "", out, 0);
            }
            out.println();
            String name = seriesDirObj.getFileName();
            if (bForWeb) {
                name = name.toLowerCase();
            }
            out.println("@series " + name);
            this.writeDescription(seriesDirObj, bForWeb, out, 1);
            this.writeGroupBody(seriesDirObj, bForWeb, out, 1);
            out.println("@end");
        }
        catch (Exception exc) {
            PersistException pe = new PersistException(3, (Object)seriesDirObj, f.getAbsolutePath(), exc);
            pe.log();
            throw pe;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    private void writeGroupBody(DirectoryObject dirObj, boolean bForWeb, PrintWriter out, int indent) throws Exception {
        String name;
        Iterator<DirectoryObject> subdirIter = dirObj.getSubDirIterator();
        while (subdirIter.hasNext()) {
            DirectoryObject subDir = subdirIter.next();
            if (bForWeb && !subDir.isToExport()) continue;
            out.println();
            name = subDir.getFileName();
            if (name.length() == 0) {
                name = subDir.getFileNamePart();
            }
            if (bForWeb) {
                name = name.toLowerCase();
            }
            this.writeValue(GROUP, name, out, indent);
            this.writeDescription(subDir, bForWeb, out, indent + 1);
            this.writeGroupBody(subDir, bForWeb, out, indent + 1);
            this.writeValue(END, "", out, indent);
        }
        Iterator<FileObject> fileIter = dirObj.getFileIterator();
        while (fileIter.hasNext()) {
            FileObject fileObj = fileIter.next();
            if (bForWeb && !fileObj.isToExport()) continue;
            out.println();
            if (fileObj.isReference()) {
                name = fileObj.getFileNamePart();
            } else if (bForWeb) {
                name = fileObj.getFileType() != 1 ? fileObj.getFileName() : fileObj.getBaseFileName() + ".jpg";
                name = name.toLowerCase();
            } else {
                name = fileObj.getFileName();
            }
            if (name.length() == 0) {
                name = fileObj.getFileNamePart();
            }
            this.writeValue(FILE, name, out, indent);
            this.writeDescription(fileObj, bForWeb, out, indent);
        }
    }

    private void writeDescription(AbstractFSObject fsObj, boolean bForWeb, PrintWriter out, int indent) throws Exception {
        String val;
        String[] propNames = fsObj.getUsedPropertyNames();
        for (int i = 0; i < propNames.length; ++i) {
            val = fsObj.getTransformed(propNames[i], true);
            if (val.length() <= 0) continue;
            this.writeValue(propNames[i], val, out, indent);
        }
        if (bForWeb) {
            val = fsObj.getTitle(false);
            if (val.length() == 0) {
                this.writeValue("title", fsObj.getTitle(true), out, indent);
            }
        } else if (fsObj.isToExport()) {
            this.writeValue(TO_EXPORT, "yes", out, indent);
            if (fsObj.getConversionQuality() > 0) {
                this.writeValue(EXPORT_QUALITY, Integer.toString(fsObj.getConversionQuality()), out, indent);
            }
        } else {
            this.writeValue(TO_EXPORT, "no", out, indent);
        }
        if (fsObj instanceof FileObject) {
            this.writeValue(END_FILE, "", out, indent);
        } else {
            this.writeValue(END_DESCRIPTION, "", out, indent);
        }
    }

    private void writeValue(String name, String value, PrintWriter out, int indent) throws Exception {
        int i;
        for (i = 0; i < indent; ++i) {
            out.print(' ');
        }
        out.print('@');
        out.print(name);
        if (value.length() > 0) {
            out.print(' ');
            int iOld = 0;
            while ((i = value.indexOf("\n", iOld)) >= 0) {
                out.println(value.substring(iOld, i));
                iOld = i + 1;
            }
            out.println(value.substring(iOld));
        } else {
            out.println();
        }
    }
}

