/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir.persist;

import com.dgrossmann.photo.dir.DirectoryObject;

public class PersistException
extends Exception {
    public static final int E_UNKNOWN = 0;
    public static final int E_LOAD_SERIES = 1;
    public static final int E_LOAD_SETTINGS = 2;
    public static final int E_SAVE_SERIES = 3;
    public static final int E_SAVE_SETTINGS = 4;
    public static final int E_ADD_CONTAINER = 5;
    private int m_errorID;
    private Object m_object;
    private String m_metaDataFileName;
    private String m_msg;
    private Exception m_e;

    public PersistException(int errorID, Object object, String metaDataFileName, String msg) {
        this.m_errorID = errorID;
        this.m_object = object;
        this.m_metaDataFileName = metaDataFileName;
        this.m_msg = msg;
        this.m_e = null;
        if (this.m_object instanceof DirectoryObject) {
            ((DirectoryObject)this.m_object).setError();
        }
    }

    public PersistException(int errorID, Object object, String metaDataFileName, Exception e) {
        this.m_errorID = errorID;
        this.m_object = object;
        this.m_metaDataFileName = metaDataFileName;
        this.m_msg = null;
        this.m_e = e;
        if (this.m_object instanceof DirectoryObject) {
            ((DirectoryObject)this.m_object).setError();
        }
    }

    @Override
    public String getMessage() {
        String msg;
        if (this.m_errorID == 5) {
            msg = "Cannot add series container for \"" + this.m_object.toString() + "\"";
        } else if (this.m_object instanceof DirectoryObject) {
            msg = "Cannot " + (this.m_errorID == 1 ? "load" : "save") + " series \"" + this.m_object + "\"";
            if (this.m_metaDataFileName != null && this.m_metaDataFileName.length() > 0) {
                msg = msg + " using metadata file \"" + this.m_metaDataFileName + "\"";
            }
        } else {
            msg = "Cannot " + (this.m_errorID == 1 || this.m_errorID == 2 ? "load" : "save") + " object \"" + this.m_object.toString();
            if (this.m_metaDataFileName != null && this.m_metaDataFileName.length() > 0) {
                msg = msg + " using file \"" + this.m_metaDataFileName + "\"";
            }
        }
        if (this.m_msg != null && this.m_msg.length() > 0) {
            msg = msg + '\n' + msg;
        } else if (this.m_e != null) {
            msg = msg + '\n' + this.m_e.toString();
        }
        return msg;
    }

    public void log() {
        System.err.println("E: " + this.getMessage());
    }
}

