/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DateChooserDialog
extends JDialog
implements ItemListener {
    private static final String SEL_SPACER = "----------";
    private Rectangle m_parentRect;
    private String m_dlgTitle;
    private boolean m_bIsChanged;
    private int m_day;
    private int m_month;
    private int m_year;
    private static final String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final int[] daysPerMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton clearDateButton;
    private JPanel contentPanel;
    private JComboBox dayComboBox;
    private JLabel dayLabel;
    private JComboBox monthComboBox;
    private JLabel monthLabel;
    private JButton okButton;
    private JLabel slashLabel;
    private JLabel slashLabel2;
    private JLabel spacerLabel;
    private JLabel titleLabel;
    private JLabel titleLabel2;
    private JComboBox yearComboBox;
    private JLabel yearLabel;

    public DateChooserDialog(Frame parent, String dateValue, String dlgTitle, boolean modal) {
        super(parent, modal);
        this.m_parentRect = parent.getBounds();
        this.m_dlgTitle = dlgTitle;
        this.initialize(dateValue);
    }

    public DateChooserDialog(Dialog parent, String dateValue, String dlgTitle, boolean modal) {
        super(parent, modal);
        this.m_parentRect = parent.getBounds();
        this.m_dlgTitle = dlgTitle;
        this.initialize(dateValue);
    }

    private void initialize(String dateValue) {
        int i;
        this.initComponents();
        this.m_bIsChanged = false;
        this.m_year = 0;
        this.m_month = 0;
        this.m_day = 0;
        if (dateValue != null && dateValue.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(dateValue, "-");
            try {
                if (tokens.hasMoreTokens()) {
                    this.m_year = Integer.parseInt(tokens.nextToken());
                }
                if (tokens.hasMoreTokens()) {
                    this.m_month = Integer.parseInt(tokens.nextToken());
                }
                if (tokens.hasMoreTokens()) {
                    this.m_day = Integer.parseInt(tokens.nextToken());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.m_dlgTitle.equalsIgnoreCase("begin")) {
            this.setTitle("Select the Begin Date");
        } else if (this.m_dlgTitle.equalsIgnoreCase("end")) {
            this.setTitle("Select the End Date");
        } else if (this.m_dlgTitle.length() == 0) {
            this.setTitle("Select Date");
        } else {
            this.setTitle(this.m_dlgTitle);
        }
        this.dayComboBox.addItem(SEL_SPACER);
        for (i = 1; i <= 31; ++i) {
            this.dayComboBox.addItem(new Integer(i));
        }
        if (this.m_day > 0) {
            this.dayComboBox.setSelectedIndex(this.m_day);
        }
        this.monthComboBox.addItem(SEL_SPACER);
        for (i = 0; i < monthNames.length; ++i) {
            this.monthComboBox.addItem(monthNames[i]);
        }
        if (this.m_month > 0) {
            this.monthComboBox.setSelectedIndex(this.m_month);
        }
        this.monthComboBox.addItemListener(this);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int firstYear = cal.get(1) - 20;
        if (this.m_year > 0 && (this.m_year < firstYear || this.m_year > cal.get(1))) {
            this.yearComboBox.addItem(new Integer(this.m_year));
        }
        this.yearComboBox.addItem(SEL_SPACER);
        for (i = cal.get(1); i >= firstYear; --i) {
            Integer yearInt = new Integer(i);
            this.yearComboBox.addItem(yearInt);
            if (this.m_year != i) continue;
            this.yearComboBox.setSelectedItem(yearInt);
        }
        Rectangle thisRect = this.getBounds();
        thisRect.x = this.m_parentRect.x + (this.m_parentRect.width - thisRect.width) / 2;
        thisRect.y = this.m_parentRect.y + (this.m_parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.m_bIsChanged;
    }

    public String getDateString() {
        String str = "";
        if (this.m_year > 0) {
            str = Integer.toString(this.m_year);
            if (this.m_month >= 1 && this.m_month <= 12) {
                str = str + "-" + this.m_month;
                if (this.m_day > 0 && this.m_day <= daysPerMonth[this.m_month - 1]) {
                    str = str + "-" + this.m_day;
                }
            }
        }
        return str;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.monthComboBox) {
            // empty if block
        }
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleLabel2 = new JLabel();
        this.dayLabel = new JLabel();
        this.monthLabel = new JLabel();
        this.yearLabel = new JLabel();
        this.dayComboBox = new JComboBox();
        this.slashLabel = new JLabel();
        this.monthComboBox = new JComboBox();
        this.slashLabel2 = new JLabel();
        this.yearComboBox = new JComboBox();
        this.clearDateButton = new JButton();
        this.spacerLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Select Date");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DateChooserDialog.this.closeDialog(evt);
            }
        });
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setMinimumSize(new Dimension(360, 118));
        this.contentPanel.setPreferredSize(new Dimension(360, 118));
        this.titleLabel.setText("Please enter the date - you may leave the day and month");
        this.titleLabel.setMaximumSize(new Dimension(3660, 17));
        this.titleLabel.setMinimumSize(new Dimension(500, 17));
        this.titleLabel.setPreferredSize(new Dimension(500, 17));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.contentPanel.add((Component)this.titleLabel, gridBagConstraints);
        this.titleLabel2.setText("empty (fill from right to left) or clear the date altogether.");
        this.titleLabel2.setVerticalAlignment(1);
        this.titleLabel2.setMaximumSize(new Dimension(2810, 17));
        this.titleLabel2.setMinimumSize(new Dimension(280, 17));
        this.titleLabel2.setPreferredSize(new Dimension(280, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.contentPanel.add((Component)this.titleLabel2, gridBagConstraints);
        this.dayLabel.setText("Day:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.contentPanel.add((Component)this.dayLabel, gridBagConstraints);
        this.monthLabel.setText("Month:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.contentPanel.add((Component)this.monthLabel, gridBagConstraints);
        this.yearLabel.setText("Year:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.contentPanel.add((Component)this.yearLabel, gridBagConstraints);
        this.dayComboBox.setEditable(true);
        this.dayComboBox.setToolTipText("Day");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.contentPanel.add((Component)this.dayComboBox, gridBagConstraints);
        this.slashLabel.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 2, 0, 0);
        this.contentPanel.add((Component)this.slashLabel, gridBagConstraints);
        this.monthComboBox.setEditable(true);
        this.monthComboBox.setToolTipText("Month");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.contentPanel.add((Component)this.monthComboBox, gridBagConstraints);
        this.slashLabel2.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 2, 0, 0);
        this.contentPanel.add((Component)this.slashLabel2, gridBagConstraints);
        this.yearComboBox.setEditable(true);
        this.yearComboBox.setToolTipText("Year");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.contentPanel.add((Component)this.yearComboBox, gridBagConstraints);
        this.clearDateButton.setText("Clear");
        this.clearDateButton.setToolTipText("Clear the date setting");
        this.clearDateButton.setMargin(new Insets(2, 2, 2, 2));
        this.clearDateButton.setMaximumSize(new Dimension(64, 25));
        this.clearDateButton.setMinimumSize(new Dimension(64, 25));
        this.clearDateButton.setPreferredSize(new Dimension(64, 25));
        this.clearDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateChooserDialog.this.clearDateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.contentPanel.add((Component)this.clearDateButton, gridBagConstraints);
        this.spacerLabel.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        this.contentPanel.add((Component)this.spacerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.contentPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateChooserDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateChooserDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void clearDateButtonActionPerformed(ActionEvent evt) {
        this.m_year = 0;
        this.m_month = 0;
        this.m_day = 0;
        this.dayComboBox.setSelectedItem(SEL_SPACER);
        this.monthComboBox.setSelectedItem(SEL_SPACER);
        this.yearComboBox.setSelectedItem(SEL_SPACER);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Object val = this.dayComboBox.getSelectedItem();
        if (val != null && val.toString().startsWith("-")) {
            this.m_day = 0;
        } else {
            try {
                this.m_day = Integer.parseInt(val.toString());
            }
            catch (Exception dayEx) {
                JOptionPane.showMessageDialog(this, "Please enter a valid day of month number", "J Photo-Explorer", 2);
                return;
            }
        }
        val = this.monthComboBox.getSelectedItem();
        if (val != null && val.toString().startsWith("-")) {
            this.m_day = 0;
            this.m_month = 0;
        } else {
            boolean bFound = false;
            for (int i = 0; i < monthNames.length; ++i) {
                if (!val.toString().equalsIgnoreCase(monthNames[i])) continue;
                this.m_month = i + 1;
                bFound = true;
            }
            if (!bFound) {
                try {
                    this.m_month = Integer.parseInt(val.toString());
                    if (this.m_month < 1 || this.m_month > 12) {
                        throw new Exception("");
                    }
                }
                catch (Exception dayEx) {
                    JOptionPane.showMessageDialog(this, "Please enter a valid month name or number", "J Photo-Explorer", 2);
                    return;
                }
            }
        }
        if (this.m_month > 0 && this.m_day > daysPerMonth[this.m_month - 1]) {
            JOptionPane.showMessageDialog(this, "Month " + monthNames[this.m_month - 1] + " does not have " + this.m_day + " days", "J Photo-Explorer", 2);
            return;
        }
        val = this.yearComboBox.getSelectedItem();
        if (val != null && val.toString().startsWith("-")) {
            this.m_day = 0;
            this.m_month = 0;
            this.m_year = 0;
        } else {
            try {
                this.m_year = Integer.parseInt(val.toString());
            }
            catch (Exception dayEx) {
                JOptionPane.showMessageDialog(this, "Please enter a valid year", "J Photo-Explorer", 2);
                return;
            }
        }
        this.m_bIsChanged = true;
        this.cancelButtonActionPerformed(evt);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

