/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EnterDirNameDialog
extends JDialog {
    private DirectoryObject m_parentDir;
    private boolean m_bIsChanged;
    private JLabel iconLabel;
    private JButton okButton;
    private JLabel descLabel;
    private JButton cancelButton;
    private JTextField dirNameTextField;
    private JPanel buttonPanel;
    private JLabel descLabel2;
    private JPanel contentPanel;

    public EnterDirNameDialog(Frame parent, DirectoryObject parentDir, boolean modal) {
        super(parent, modal);
        this.m_parentDir = parentDir;
        this.m_bIsChanged = false;
        this.initComponents();
        this.descLabel.setText("This dialog creates a new folder under \"" + parentDir.getFileName() + "\".");
        Rectangle parentRect = parent.getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
        this.setResizable(false);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.m_bIsChanged;
    }

    public String getDirName() {
        return this.dirNameTextField.getText();
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.descLabel = new JLabel();
        this.descLabel2 = new JLabel();
        this.dirNameTextField = new JTextField();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("New Subfolder");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EnterDirNameDialog.this.closeDialog(evt);
            }
        });
        this.contentPanel.setLayout(new GridBagLayout());
        this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/type-dir.gif")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.contentPanel.add((Component)this.iconLabel, gridBagConstraints);
        this.descLabel.setText("This dialog creates a new folder under");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.contentPanel.add((Component)this.descLabel, gridBagConstraints);
        this.descLabel2.setText("Please enter the name of the new folder:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 12, 0, 150);
        gridBagConstraints.anchor = 18;
        this.contentPanel.add((Component)this.descLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 4);
        this.contentPanel.add((Component)this.dirNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.contentPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnterDirNameDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnterDirNameDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String name = this.dirNameTextField.getText();
        if (name == null || name.length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter a folder name.", "J Photo-Explorer", 2);
            return;
        }
        boolean bFound = false;
        Iterator<DirectoryObject> subDirIter = this.m_parentDir.getSubDirIterator();
        while (subDirIter.hasNext()) {
            if (!subDirIter.next().getFileName().equalsIgnoreCase(name)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            Iterator<FileObject> fileIter = this.m_parentDir.getFileIterator();
            while (fileIter.hasNext()) {
                if (!fileIter.next().getFileName().equalsIgnoreCase(name)) continue;
                bFound = true;
                break;
            }
        }
        if (bFound) {
            JOptionPane.showMessageDialog(this, "\"" + name + "\" is already used in the parent " + "directory \"" + this.m_parentDir.getFileName() + "\".\n\nPlease enter a different directory name.", "J Photo-Explorer", 2);
            return;
        }
        this.m_bIsChanged = true;
        this.cancelButtonActionPerformed(evt);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

