/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.settings.Settings;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExportSelDialog
extends JDialog
implements ItemListener {
    private static final String SEP = "------------------------------";
    private SeriesContainer m_seriesContainer;
    private Settings m_settings;
    private boolean m_bIsChanged;
    private DirectoryObject[] m_seriesDirs;
    private DirectoryObject m_currentSeries;
    private DirectoryObject m_currentGroup;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel exportDirLabel;
    private JCheckBox forceCheckBox;
    private JCheckBox indexImgCheckBox;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JComboBox mainGroupComboBox;
    private JCheckBox mainImgCheckBox;
    private JButton okButton;
    private JComboBox seriesComboBox;
    private JLabel titleNewerLabel;
    private JLabel titleToLabel;
    private JPanel whichImagesPanel;
    private JPanel whichSeriesPanel;

    public ExportSelDialog(Frame parent, SeriesContainer sContainer, Settings settings, boolean modal) {
        super(parent, modal);
        this.m_seriesContainer = sContainer;
        this.m_seriesDirs = this.m_seriesContainer.getSeriesDirectories();
        this.m_currentGroup = null;
        this.m_currentSeries = null;
        this.m_settings = settings;
        this.m_bIsChanged = false;
        this.initComponents();
        this.exportDirLabel.setText(this.m_settings.get("export.dir"));
        this.seriesComboBox.addItem("All");
        this.seriesComboBox.addItem(SEP);
        for (int i = 0; i < this.m_seriesDirs.length; ++i) {
            this.m_seriesContainer.ensureLoaded(this.m_seriesDirs[i]);
            this.seriesComboBox.addItem(this.m_seriesDirs[i].getTitlePlain());
        }
        this.seriesComboBox.addItemListener(this);
        this.mainGroupComboBox.addItem("All");
        this.mainGroupComboBox.addItem(SEP);
        this.mainGroupComboBox.setEnabled(false);
        this.mainGroupComboBox.addItemListener(this);
        Rectangle parentRect = parent.getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.m_bIsChanged;
    }

    public DirectoryObject getSeries() {
        return this.m_currentSeries;
    }

    public DirectoryObject getGroup() {
        return this.m_currentGroup;
    }

    public boolean getExportMain() {
        return this.mainImgCheckBox.isSelected();
    }

    public boolean getExportIndex() {
        return this.indexImgCheckBox.isSelected();
    }

    public boolean getForceExport() {
        return this.forceCheckBox.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.seriesComboBox) {
            int index = this.seriesComboBox.getSelectedIndex();
            index -= 2;
            this.m_currentGroup = null;
            this.m_currentSeries = null;
            this.mainGroupComboBox.removeAllItems();
            this.mainGroupComboBox.addItem("All");
            this.mainGroupComboBox.addItem(SEP);
            if (index < 0 || index >= this.m_seriesDirs.length) {
                this.mainGroupComboBox.setEnabled(false);
                return;
            }
            this.m_currentSeries = this.m_seriesDirs[index];
            this.mainGroupComboBox.setEnabled(true);
            Iterator<DirectoryObject> subDirIter = this.m_currentSeries.getSubDirIterator();
            while (subDirIter.hasNext()) {
                this.mainGroupComboBox.addItem(subDirIter.next().getTitlePlain());
            }
            return;
        }
        if (e.getSource() == this.mainGroupComboBox) {
            int index = this.mainGroupComboBox.getSelectedIndex();
            index -= 2;
            this.m_currentGroup = null;
            if (this.m_currentSeries == null) {
                return;
            }
            this.m_currentGroup = this.m_currentSeries.getSubDirAt(index);
        }
    }

    private void initComponents() {
        this.titleToLabel = new JLabel();
        this.exportDirLabel = new JLabel();
        this.titleNewerLabel = new JLabel();
        this.whichSeriesPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.seriesComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.mainGroupComboBox = new JComboBox();
        this.whichImagesPanel = new JPanel();
        this.jLabel21 = new JLabel();
        this.mainImgCheckBox = new JCheckBox();
        this.indexImgCheckBox = new JCheckBox();
        this.forceCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Export for the Web");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExportSelDialog.this.closeDialog(evt);
            }
        });
        this.titleToLabel.setText("This dialog exports either all files or all files of a series to the Web export directory:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.titleToLabel, gridBagConstraints);
        this.exportDirLabel.setHorizontalAlignment(0);
        this.exportDirLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 6);
        this.getContentPane().add((Component)this.exportDirLabel, gridBagConstraints);
        this.titleNewerLabel.setText("Only the files that are newer than those in the export directory are processed.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 6, 6);
        this.getContentPane().add((Component)this.titleNewerLabel, gridBagConstraints);
        this.whichSeriesPanel.setLayout(new GridBagLayout());
        this.whichSeriesPanel.setBorder(BorderFactory.createTitledBorder(null, "Which Series"));
        this.jLabel2.setText("Specify whether all series, or only one series or group, are processed:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.whichSeriesPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Series:");
        this.jLabel3.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.whichSeriesPanel.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.whichSeriesPanel.add((Component)this.seriesComboBox, gridBagConstraints);
        this.jLabel4.setText("Main Group:");
        this.jLabel4.setToolTipText("Main groups are direct subgroups of a series");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.whichSeriesPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.mainGroupComboBox.setToolTipText("Main groups are direct subgroups of a series");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.whichSeriesPanel.add((Component)this.mainGroupComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.whichSeriesPanel, gridBagConstraints);
        this.whichImagesPanel.setLayout(new GridBagLayout());
        this.whichImagesPanel.setBorder(BorderFactory.createTitledBorder(null, "Which Image Size Types"));
        this.jLabel21.setText("Specify which image size types should be generated:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.whichImagesPanel.add((Component)this.jLabel21, gridBagConstraints);
        this.mainImgCheckBox.setSelected(true);
        this.mainImgCheckBox.setText("Main Images (one per Web page)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.whichImagesPanel.add((Component)this.mainImgCheckBox, gridBagConstraints);
        this.indexImgCheckBox.setSelected(true);
        this.indexImgCheckBox.setText("Index Images (small for overview pages)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.whichImagesPanel.add((Component)this.indexImgCheckBox, gridBagConstraints);
        this.forceCheckBox.setText("Always generate images (even if the exported images are newer)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 6, 0);
        this.whichImagesPanel.add((Component)this.forceCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.whichImagesPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportSelDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportSelDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.m_bIsChanged = true;
        this.cancelButtonActionPerformed(evt);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

