/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.ui.ImageHolder;
import com.dgrossmann.photo.ui.ShellExec;
import com.dgrossmann.photo.ui.dialog.DateChooserDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PropertiesDialog
extends JDialog
implements ItemListener {
    private ExplorerMainFrame m_parent;
    private ImageHolder m_imgHolder;
    private AbstractFSObject m_fileObj;
    private String m_oldFileName;
    private String m_beginDate;
    private String m_endDate;
    private int m_exportQuality;
    private boolean m_isChanged;
    private JLabel endDateLabel;
    private JTextField endDateText;
    private JButton setEndDateButton;
    private JLabel hrefLabel;
    private JTextField hrefText;
    private JLabel beginDateLabel;
    private JTextField beginDateText;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel dataPanel;
    private JLabel descLabel;
    private JPanel descPanel;
    private JScrollPane descScrollPane;
    private JTextArea descTextArea;
    private JPanel exportPanel;
    private JPanel fileSsizePanel;
    private JLabel indexSizeLabel;
    private JLabel indexSizeTextLabel;
    private JLabel locationLabel;
    private JTextField locationText;
    private JLabel mainSizeLabel;
    private JLabel mainSizeTextLabel;
    private JLabel modDateLabel;
    private JLabel modDateValueLabel;
    private JLabel nameLabel;
    private JTextField nameText;
    private JButton okButton;
    private JButton openButton;
    private JLabel percentLabel;
    private JLabel previewImgLabel;
    private JPanel previewPanel;
    private JPanel propertiesPanel;
    private JLabel qualityLabel;
    private JTextField qualityText;
    private JButton setBeginDateButton;
    private JLabel subTitleLabel;
    private JTextField subTitleText;
    private JLabel titleLabel;
    private JTextField titleText;
    private JCheckBox toExportCheckBox;

    public PropertiesDialog(ImageHolder imgHolder, AbstractFSObject fileObj, File[] exportedFiles, ExplorerMainFrame parent, boolean modal) {
        super((Frame)parent, modal);
        String str;
        GridBagConstraints gridBagConstraints;
        this.m_parent = parent;
        this.m_imgHolder = imgHolder;
        this.m_fileObj = fileObj;
        this.m_isChanged = false;
        if (this.m_fileObj == null) {
            return;
        }
        this.m_beginDate = fileObj.get("date-begin");
        this.m_endDate = fileObj.get("date-end");
        this.hrefLabel = null;
        this.endDateLabel = null;
        this.hrefText = null;
        this.endDateText = null;
        this.setEndDateButton = null;
        parent.setCursor(new Cursor(3));
        this.initComponents();
        String tit = "";
        String tend = "";
        if (this.m_fileObj.getParent() == null) {
            tit = "Series \"";
            tend = "\"";
            this.descLabel.setText("Series description:");
        } else if (this.m_fileObj instanceof DirectoryObject) {
            tit = "Group \"";
            tend = "\"";
            this.descLabel.setText("Group description:");
        } else {
            this.descLabel.setText("Description:");
        }
        tit = tit + this.m_fileObj.getTitlePlain();
        if (tit.length() > 0) {
            tit = tit + tend + " - ";
        }
        this.setTitle(tit + "Properties");
        int currentRow = 6;
        if (this.m_fileObj instanceof DirectoryObject) {
            tit = this.m_fileObj.getParent() == null ? " date of this series" : " date of this group";
            this.endDateLabel = new JLabel();
            this.endDateLabel.setText("End Date: ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = currentRow;
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            this.dataPanel.add((Component)this.endDateLabel, gridBagConstraints);
            this.endDateText = new JTextField();
            this.endDateText.setEditable(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = currentRow;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 100.0;
            this.dataPanel.add((Component)this.endDateText, gridBagConstraints);
            this.setEndDateButton = new JButton();
            this.setEndDateButton.setText("...");
            this.setEndDateButton.setToolTipText("Select the end" + tit);
            this.setEndDateButton.setMaximumSize(new Dimension(30, 20));
            this.setEndDateButton.setMinimumSize(new Dimension(30, 20));
            this.setEndDateButton.setPreferredSize(new Dimension(30, 20));
            this.setEndDateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PropertiesDialog.this.setEndDateButtonActionPerformed(evt);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = currentRow;
            gridBagConstraints.insets = new Insets(4, 4, 0, 0);
            gridBagConstraints.anchor = 17;
            this.dataPanel.add((Component)this.setEndDateButton, gridBagConstraints);
            this.nameLabel.setText("Name: ");
            this.beginDateLabel.setText("Begin Date: ");
            this.setBeginDateButton.setToolTipText("Select the begin" + tit);
            this.endDateText.setText(fileObj.expandDate(this.m_endDate, false));
        }
        if (this.m_fileObj.isReference()) {
            this.hrefLabel = new JLabel();
            this.hrefLabel.setText("Referenced Document URL:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = currentRow++;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            this.dataPanel.add((Component)this.hrefLabel, gridBagConstraints);
            this.hrefText = new JTextField();
            this.hrefText.setToolTipText("URL of the document that should be referenced");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = currentRow;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 100.0;
            this.dataPanel.add((Component)this.hrefText, gridBagConstraints);
            this.nameText.setEnabled(false);
            this.nameText.setEditable(false);
            tit = this.m_fileObj.getFileNamePart();
            if (tit.length() == 0) {
                tit = this.m_fileObj.getFileName();
            }
            if (tit.length() > 0 && !tit.equalsIgnoreCase("reference:")) {
                this.nameText.setText("(" + tit + ")");
            }
            this.hrefText.setText(this.m_fileObj.get("href"));
        }
        this.m_oldFileName = this.m_fileObj.getFileName();
        this.nameText.setText(this.m_oldFileName);
        this.openButton.setEnabled(this.m_fileObj instanceof FileObject && !this.m_fileObj.isReference());
        String moddate = this.m_fileObj.getModDateTimeString(false);
        if (!this.m_fileObj.isReference()) {
            String sz = this.m_fileObj.getFileSizeStr(true);
            if (sz != null) {
                moddate = moddate + "    Size: " + sz;
            }
        } else {
            this.modDateLabel.setText("");
        }
        this.modDateValueLabel.setText(moddate);
        this.titleText.setText(AbstractFSObject.transformAccents(this.m_fileObj.getTitle(true), false));
        this.titleText.requestFocus();
        this.subTitleText.setText(AbstractFSObject.transformAccents(this.m_fileObj.get("subtitle"), false));
        this.locationText.setText(AbstractFSObject.transformAccents(this.m_fileObj.get("location"), false));
        this.beginDateText.setText(fileObj.expandDate(this.m_beginDate, false));
        this.descTextArea.setText(AbstractFSObject.transformAccents(this.m_fileObj.get("description"), false));
        this.descTextArea.select(0, 0);
        this.toExportCheckBox.setSelected(this.m_fileObj.isToExport());
        this.toExportCheckBox.addItemListener(this);
        this.qualityText.setEnabled(this.m_fileObj.isToExport());
        this.m_exportQuality = this.m_fileObj.getConversionQuality();
        if (this.m_fileObj.isToExport() && this.m_exportQuality > 0) {
            this.qualityText.setText(Integer.toString(this.m_exportQuality));
        } else {
            this.qualityText.setText("Default");
            this.m_exportQuality = 0;
        }
        this.mainSizeTextLabel.setText("---");
        this.indexSizeTextLabel.setText("---");
        if (this.m_fileObj instanceof FileObject && exportedFiles != null) {
            if (exportedFiles[0] != null) {
                long len = exportedFiles[0].length() / 1024L;
                if (len <= 0L) {
                    len = 1L;
                }
                this.mainSizeTextLabel.setText(Long.toString(len) + " KB");
            }
            if (exportedFiles[1] != null) {
                long len = exportedFiles[1].length() / 1024L;
                if (len <= 0L) {
                    len = 1L;
                }
                this.indexSizeTextLabel.setText(Long.toString(len) + " KB");
            }
        }
        Rectangle parentRect = parent.getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
        this.m_imgHolder.addTransientScaleCategory("prop");
        Dimension pSize = this.previewPanel.getSize();
        pSize.width = pSize.height;
        this.previewPanel.setSize(pSize);
        ImageIcon previewImg = this.m_imgHolder.getTypeImage(this.m_fileObj, true, "prop", pSize.height, this, true);
        if (previewImg != null) {
            this.previewImgLabel.setIcon(previewImg);
            if (this.m_fileObj instanceof FileObject && ((FileObject)this.m_fileObj).getFileType() == 1) {
                this.previewImgLabel.setToolTipText(null);
            }
        }
        if ((str = this.m_imgHolder.getLastError()).length() > 0) {
            JOptionPane.showMessageDialog(this, str, "J Photo-Explorer", 0);
            this.previewImgLabel.setText("Preview not available");
        }
        if (this.m_fileObj instanceof FileObject && ((FileObject)this.m_fileObj).getFileType() == 2) {
            this.previewImgLabel.setText("Preview not available");
        }
        parent.setCursor(new Cursor(0));
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.m_isChanged;
    }

    private String getPropertiesHeading() {
        if (this.m_fileObj instanceof DirectoryObject) {
            return "Folder Properties";
        }
        return "File Properties";
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.toExportCheckBox) {
            if (this.toExportCheckBox.isSelected()) {
                this.qualityText.setEnabled(true);
                if (this.m_exportQuality == 0) {
                    this.qualityText.setText("Default");
                } else {
                    this.qualityText.setText(Integer.toString(this.m_exportQuality));
                }
            } else {
                try {
                    this.m_exportQuality = Integer.parseInt(this.qualityText.getText().trim());
                }
                catch (Exception exc) {
                    this.m_exportQuality = 0;
                }
                this.qualityText.setEnabled(false);
                this.qualityText.setText("Default");
            }
            return;
        }
    }

    private void initComponents() {
        this.propertiesPanel = new JPanel();
        this.previewPanel = new JPanel();
        this.previewImgLabel = new JLabel();
        this.dataPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.openButton = new JButton();
        this.modDateLabel = new JLabel();
        this.modDateValueLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.titleText = new JTextField();
        this.subTitleLabel = new JLabel();
        this.subTitleText = new JTextField();
        this.locationLabel = new JLabel();
        this.locationText = new JTextField();
        this.beginDateLabel = new JLabel();
        this.beginDateText = new JTextField();
        this.setBeginDateButton = new JButton();
        this.descPanel = new JPanel();
        this.descLabel = new JLabel();
        this.descScrollPane = new JScrollPane();
        this.descTextArea = new JTextArea();
        this.exportPanel = new JPanel();
        this.toExportCheckBox = new JCheckBox();
        this.qualityLabel = new JLabel();
        this.qualityText = new JTextField();
        this.percentLabel = new JLabel();
        this.fileSsizePanel = new JPanel();
        this.mainSizeLabel = new JLabel();
        this.mainSizeTextLabel = new JLabel();
        this.indexSizeLabel = new JLabel();
        this.indexSizeTextLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Properties");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PropertiesDialog.this.closeDialog(evt);
            }
        });
        this.propertiesPanel.setLayout(new GridBagLayout());
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder(null, this.getPropertiesHeading()));
        this.previewPanel.setLayout(new BorderLayout());
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.previewPanel.setMinimumSize(new Dimension(170, 170));
        this.previewPanel.setPreferredSize(new Dimension(170, 170));
        this.previewImgLabel.setForeground(new Color(102, 102, 102));
        this.previewImgLabel.setHorizontalAlignment(0);
        this.previewImgLabel.setToolTipText("Preview image (if available)");
        this.previewImgLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.previewImgLabel.setMinimumSize(new Dimension(100, 100));
        this.previewImgLabel.setPreferredSize(new Dimension(160, 160));
        this.previewPanel.add((Component)this.previewImgLabel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.propertiesPanel.add((Component)this.previewPanel, gridBagConstraints);
        this.dataPanel.setLayout(new GridBagLayout());
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setText("File Name:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.dataPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.dataPanel.add((Component)this.nameText, gridBagConstraints);
        this.openButton.setText("Open");
        this.openButton.setMaximumSize(new Dimension(72, 22));
        this.openButton.setMinimumSize(new Dimension(72, 22));
        this.openButton.setPreferredSize(new Dimension(72, 22));
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.openButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.dataPanel.add((Component)this.openButton, gridBagConstraints);
        this.modDateLabel.setText("Last Modified:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.dataPanel.add((Component)this.modDateLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.dataPanel.add((Component)this.modDateValueLabel, gridBagConstraints);
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setText("Title:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.dataPanel.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.dataPanel.add((Component)this.titleText, gridBagConstraints);
        this.subTitleLabel.setHorizontalAlignment(2);
        this.subTitleLabel.setText("Subtitle:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.dataPanel.add((Component)this.subTitleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.dataPanel.add((Component)this.subTitleText, gridBagConstraints);
        this.locationLabel.setHorizontalAlignment(2);
        this.locationLabel.setText("Location:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.dataPanel.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.dataPanel.add((Component)this.locationText, gridBagConstraints);
        this.beginDateLabel.setText("Date: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.dataPanel.add((Component)this.beginDateLabel, gridBagConstraints);
        this.beginDateText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.dataPanel.add((Component)this.beginDateText, gridBagConstraints);
        this.setBeginDateButton.setText("...");
        this.setBeginDateButton.setToolTipText("Select the date of this image");
        this.setBeginDateButton.setMaximumSize(new Dimension(30, 20));
        this.setBeginDateButton.setMinimumSize(new Dimension(30, 20));
        this.setBeginDateButton.setPreferredSize(new Dimension(30, 20));
        this.setBeginDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.setBeginDateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.dataPanel.add((Component)this.setBeginDateButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.propertiesPanel.add((Component)this.dataPanel, gridBagConstraints);
        this.descPanel.setLayout(new BorderLayout());
        this.descLabel.setText("Description:");
        this.descPanel.add((Component)this.descLabel, "North");
        this.descTextArea.setColumns(80);
        this.descTextArea.setFont(new Font("Monospaced", 0, 12));
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setRows(10);
        this.descTextArea.setWrapStyleWord(true);
        this.descScrollPane.setViewportView(this.descTextArea);
        this.descPanel.add((Component)this.descScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.propertiesPanel.add((Component)this.descPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.propertiesPanel, gridBagConstraints);
        this.exportPanel.setLayout(new GridBagLayout());
        this.exportPanel.setBorder(BorderFactory.createTitledBorder(null, "Export for the Web"));
        this.toExportCheckBox.setText("Export to Web Directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.exportPanel.add((Component)this.toExportCheckBox, gridBagConstraints);
        this.qualityLabel.setText("JPEG Quality:");
        this.qualityLabel.setToolTipText("Quality for the JPEG conversion (0 - 100%)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.exportPanel.add((Component)this.qualityLabel, gridBagConstraints);
        this.qualityText.setText("Default");
        this.qualityText.setToolTipText("Quality for the JPEG conversion (0 - 100%)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.exportPanel.add((Component)this.qualityText, gridBagConstraints);
        this.percentLabel.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 4);
        this.exportPanel.add((Component)this.percentLabel, gridBagConstraints);
        this.fileSsizePanel.setLayout(new GridBagLayout());
        this.mainSizeLabel.setText("Main Image Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.fileSsizePanel.add((Component)this.mainSizeLabel, gridBagConstraints);
        this.mainSizeTextLabel.setText("3333 KB");
        this.mainSizeTextLabel.setPreferredSize(new Dimension(60, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.fileSsizePanel.add((Component)this.mainSizeTextLabel, gridBagConstraints);
        this.indexSizeLabel.setText("Index Image Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.fileSsizePanel.add((Component)this.indexSizeLabel, gridBagConstraints);
        this.indexSizeTextLabel.setText("3333 KB");
        this.indexSizeTextLabel.setPreferredSize(new Dimension(60, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.fileSsizePanel.add((Component)this.indexSizeTextLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.exportPanel.add((Component)this.fileSsizePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.exportPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertiesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void setEndDateButtonActionPerformed(ActionEvent evt) {
        DateChooserDialog dlg = new DateChooserDialog((Dialog)this, this.m_endDate, "end", true);
        if (!dlg.showDialog()) {
            return;
        }
        this.m_endDate = dlg.getDateString();
        if (this.endDateText != null) {
            this.endDateText.setText(this.m_fileObj.expandDate(this.m_endDate, false));
        }
    }

    private void setBeginDateButtonActionPerformed(ActionEvent evt) {
        String dlgTitle = this.m_fileObj instanceof DirectoryObject ? "begin" : "";
        DateChooserDialog dlg = new DateChooserDialog((Dialog)this, this.m_beginDate, dlgTitle, true);
        if (!dlg.showDialog()) {
            return;
        }
        this.m_beginDate = dlg.getDateString();
        this.beginDateText.setText(this.m_fileObj.expandDate(this.m_beginDate, false));
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        if (this.m_fileObj.isReference() || !(this.m_fileObj instanceof FileObject)) {
            return;
        }
        ShellExec exec = new ShellExec(this);
        exec.openDocument((FileObject)this.m_fileObj);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String s;
        if (this.toExportCheckBox.isSelected()) {
            try {
                this.m_exportQuality = Integer.parseInt(this.qualityText.getText().trim());
            }
            catch (Exception e) {
                this.m_exportQuality = 0;
            }
            if (this.m_exportQuality < 0 || this.m_exportQuality > 100) {
                JOptionPane.showMessageDialog(this, "The JPEG conversion quality must be between 0 and 100", "J Photo-Explorer", 2);
                return;
            }
            this.m_fileObj.setToExport(true);
            this.m_fileObj.setConversionQuality(this.m_exportQuality);
        } else {
            this.m_fileObj.setToExport(false);
            this.m_fileObj.setConversionQuality(0);
        }
        if (!this.m_fileObj.isReference() && (s = this.nameText.getText()) != null && s.length() > 0 && !s.equalsIgnoreCase(this.m_oldFileName)) {
            File f;
            if (this.m_fileObj.getParent() != null && (f = new File(this.m_fileObj.getParent().getFileName(), s)).exists()) {
                JOptionPane.showMessageDialog(this.m_parent, "Cannot rename as a file with the following name already exists:\n" + f.getAbsolutePath(), "J Photo-Explorer", 2);
                return;
            }
            this.m_imgHolder.renameThumbnails(this.m_fileObj, s);
            this.m_parent.renameExportedFiles(this.m_fileObj, null, s);
            this.m_fileObj.setFileName(s, true);
        }
        if ((s = this.titleText.getText()) != null) {
            this.m_fileObj.set("title", s.trim());
        }
        if ((s = this.subTitleText.getText()) != null) {
            this.m_fileObj.set("subtitle", s.trim());
        }
        if (this.m_fileObj.isReference() && (s = this.hrefText.getText()) != null) {
            this.m_fileObj.set("href", s.trim());
        }
        if ((s = this.locationText.getText()) != null) {
            this.m_fileObj.set("location", s.trim());
        }
        if ((s = this.descTextArea.getText()) != null) {
            this.m_fileObj.set("description", s.trim());
        }
        this.m_fileObj.set("date-begin", this.m_beginDate);
        if (this.m_fileObj instanceof DirectoryObject) {
            this.m_fileObj.set("date-end", this.m_endDate);
        }
        if (this.m_fileObj instanceof FileObject) {
            DirectoryObject parentDir = (DirectoryObject)this.m_fileObj.getParent();
            if (parentDir != null) {
                parentDir.setChanged();
            }
        } else if (this.m_fileObj instanceof DirectoryObject) {
            ((DirectoryObject)this.m_fileObj).setChanged();
        }
        this.m_isChanged = true;
        this.cancelButtonActionPerformed(evt);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        Runtime.getRuntime().gc();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        Runtime.getRuntime().gc();
    }
}

