/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.webexport.ImageMagickExporter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SettingsDialog
extends JDialog
implements ListSelectionListener,
ChangeListener {
    private ExplorerMainFrame m_frame;
    private Settings m_settings;
    private SeriesContainer m_seriesContainer;
    private Vector<String> m_seriesContainerNames;
    private String m_currentSContainerDir;
    private boolean m_isChanged;
    private boolean m_bHaveImageMagick;
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel contentsPanelOptionsPanel;
    private JPanel convSizePanel;
    private JPanel convToolPanel1;
    private JButton delButton;
    private JPanel dirTreePanelOptionsPanel;
    private JCheckBox doubleClickOpensDirCheckBox;
    private JCheckBox doubleClickOpensFileCheckBox;
    private JCheckBox exportAsXmlCheckBox;
    private JLabel exportDirLabel;
    private JLabel exportDirLabel1;
    private JLabel exportDirLabel2;
    private JLabel exportDirLabel3;
    private JLabel exportDirLabel4;
    private JLabel exportDirLabel5;
    private JPanel exportDirPanel;
    private JButton exportDirSelButton;
    private JTextField exportDirText;
    private JLabel exportEncodingLabel;
    private JTextField exportEncodingTextField;
    private JLabel exportLabel;
    private JPanel exportPanel;
    private JLabel exportTitleLabel;
    private JLabel indexImageLabel;
    private JLabel indexLengthLabel;
    private JTextField indexLengthText;
    private JLabel indexQualityLabel;
    private JTextField indexQualityText;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTabbedPane jTabbedPane;
    private JPanel listPanel;
    private JLabel mainImageLabel;
    private JLabel mainMaxWidthLabel;
    private JTextField mainMaxWidthText;
    private JLabel mainMaxHeightLabel;
    private JTextField mainMaxHeightText;
    private JLabel mainQualityLabel;
    private JTextField mainQualityText;
    private JLabel mainLengthLabel;
    private JTextField mainLengthText;
    private JPanel metadataFormatPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton okButton;
    private JPanel panelOptionsPanel;
    private JLabel percentLabel;
    private JLabel percentLabel1;
    private JLabel restartLabel;
    private JLabel restartLabel2;
    private JList sContainerDirList;
    private JTextField sCopyrightText;
    private JTextArea sDescTextArea;
    private JPanel sTitlePanel;
    private JTextField sTitleText;
    private JCheckBox saveAsXMLCheckBox;
    private JCheckBox saveCurrentDirCheckBox;
    private JLabel saveEncodingLabel;
    private JTextField saveEncodingTextField;
    private JLabel saveLabel;
    private JPanel savePanel;
    private JLabel saveTitleLabel;
    private JPanel seriesPanel;
    private JLabel titleLabel;
    private JLabel titleLabel1;
    private JLabel titleLabel2;
    private JCheckBox useMagickCheckBox;
    private JLabel useMagickDescLabel;

    public SettingsDialog(ExplorerMainFrame frame, SeriesContainer seriesContainer, Settings settings, boolean modal) {
        super((Frame)frame, modal);
        String enc;
        this.initComponents();
        this.m_frame = frame;
        this.m_settings = settings;
        this.m_seriesContainer = seriesContainer;
        this.m_isChanged = false;
        this.m_currentSContainerDir = null;
        this.restartLabel.setFont(this.restartLabel.getFont().deriveFont(1));
        this.m_seriesContainerNames = new Vector(20);
        Iterator<String> sIter = this.m_settings.getSeriesContainerNameIterator();
        while (sIter.hasNext()) {
            this.m_seriesContainerNames.add(sIter.next());
        }
        this.sContainerDirList.setListData(this.m_seriesContainerNames);
        this.sContainerDirList.setSelectionMode(0);
        this.sContainerDirList.addListSelectionListener(this);
        this.sTitleText.setText(this.m_settings.get("gallery.title"));
        this.sDescTextArea.setText(this.m_settings.get("gallery.description"));
        this.sDescTextArea.select(0, 0);
        String text = this.m_settings.get("gallery.copyright");
        if (text == null || text.length() == 0) {
            text = "\u00a9 ${year}";
        }
        this.sCopyrightText.setText(text);
        this.exportDirText.setText(this.m_settings.get("export.dir"));
        this.mainLengthText.setText(this.m_settings.get("export.mainimg.length", Integer.toString(600)));
        this.mainMaxWidthText.setText(this.m_settings.get("export.mainimg.max_width", Integer.toString(700)));
        this.mainMaxHeightText.setText(this.m_settings.get("export.mainimg.max_height", Integer.toString(450)));
        this.mainQualityText.setText(this.m_settings.get("export.mainimg.quality", Integer.toString(85)));
        this.indexLengthText.setText(this.m_settings.get("export.indeximg.length", Integer.toString(200)));
        this.indexQualityText.setText(this.m_settings.get("export.indeximg.quality", Integer.toString(75)));
        ImageMagickExporter magickExporter = new ImageMagickExporter();
        this.m_bHaveImageMagick = false;
        if (magickExporter.isAvailable()) {
            this.m_bHaveImageMagick = true;
            this.useMagickCheckBox.setSelected(this.m_settings.getInt("export.use_magick", 0) > 0);
        } else {
            this.useMagickCheckBox.setSelected(false);
            this.useMagickCheckBox.setEnabled(false);
            this.useMagickDescLabel.setText("(ImageMagick is not installed)");
            this.useMagickDescLabel.setForeground(new Color(0, 70, 213));
        }
        this.saveAsXMLCheckBox.setSelected(this.m_settings.getBoolean("metadata.save.xml", true));
        this.saveAsXMLCheckBox.addChangeListener(this);
        if (this.saveAsXMLCheckBox.isSelected()) {
            enc = this.m_settings.get("metadata.save.xml.encoding");
            this.saveEncodingTextField.setText(enc.length() > 0 ? enc : "ISO-8859-1");
        } else {
            this.saveEncodingTextField.setEnabled(false);
        }
        this.exportAsXmlCheckBox.setSelected(this.m_settings.getBoolean("metadata.export.xml", true));
        this.exportAsXmlCheckBox.addChangeListener(this);
        if (this.saveAsXMLCheckBox.isSelected()) {
            enc = this.m_settings.get("metadata.export.xml.encoding");
            this.exportEncodingTextField.setText(enc.length() > 0 ? enc : "ISO-8859-1");
        } else {
            this.exportEncodingTextField.setEnabled(false);
        }
        this.saveCurrentDirCheckBox.setSelected(this.m_settings.getBoolean("dirtree.save_current_dir_on_exit", false));
        this.doubleClickOpensDirCheckBox.setSelected(this.m_settings.getBoolean("contents.dbl_click_on_dir_opens", false));
        this.doubleClickOpensFileCheckBox.setSelected(this.m_settings.getBoolean("contents.dbl_click_on_file_opens", false));
        this.delButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        Rectangle parentRect = frame.getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.m_isChanged;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int index;
        boolean bHasNewSelection = false;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.m_currentSContainerDir = null;
        Object val = this.sContainerDirList.getSelectedValue();
        if (val != null) {
            this.m_currentSContainerDir = (String)val;
            bHasNewSelection = true;
        }
        this.moveUpButton.setEnabled((index = this.sContainerDirList.getSelectedIndex()) > 0 && index < this.m_seriesContainerNames.size());
        this.moveDownButton.setEnabled(index >= 0 && index < this.m_seriesContainerNames.size() - 1);
        this.delButton.setEnabled(bHasNewSelection);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.saveAsXMLCheckBox) {
            if (this.saveAsXMLCheckBox.isSelected()) {
                this.saveEncodingTextField.setEnabled(true);
                String text = this.saveEncodingTextField.getText();
                if (text == null || text.length() == 0) {
                    this.saveEncodingTextField.setText("ISO-8859-1");
                }
            } else {
                this.saveEncodingTextField.setEnabled(false);
                String text = this.saveEncodingTextField.getText();
                if (text != null && text.equalsIgnoreCase("ISO-8859-1")) {
                    this.saveEncodingTextField.setText("");
                }
            }
        } else if (e.getSource() == this.exportAsXmlCheckBox) {
            if (this.exportAsXmlCheckBox.isSelected()) {
                this.exportEncodingTextField.setEnabled(true);
                String text = this.exportEncodingTextField.getText();
                if (text == null || text.length() == 0) {
                    this.exportEncodingTextField.setText("ISO-8859-1");
                }
            } else {
                this.exportEncodingTextField.setEnabled(false);
                String text = this.exportEncodingTextField.getText();
                if (text != null && text.equalsIgnoreCase("ISO-8859-1")) {
                    this.exportEncodingTextField.setText("");
                }
            }
        }
    }

    private Integer validateInt(JTextField textField, String fieldDesc, int tabIndex, int minValue, int maxValue) {
        boolean bOK = true;
        int val = -1;
        String msg = "";
        String s = textField.getText().trim();
        try {
            val = Integer.parseInt(s);
        }
        catch (Exception e) {
            bOK = false;
            msg = "Please enter a number in the field \"" + fieldDesc + "\"";
        }
        if (bOK && minValue <= maxValue && (val < minValue || val > maxValue)) {
            bOK = false;
            msg = "The value of \"" + fieldDesc + "\" (" + val + ") has to be between " + minValue + " and " + maxValue;
        }
        if (bOK) {
            return new Integer(val);
        }
        JOptionPane.showMessageDialog(this, msg, "J Photo-Explorer", 2);
        this.jTabbedPane.setSelectedIndex(tabIndex);
        textField.requestFocus();
        return null;
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.seriesPanel = new JPanel();
        this.listPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleLabel1 = new JLabel();
        this.titleLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.sContainerDirList = new JList();
        this.addButton = new JButton();
        this.delButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.sTitlePanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.sTitleText = new JTextField();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.sDescTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.sCopyrightText = new JTextField();
        this.exportPanel = new JPanel();
        this.exportDirPanel = new JPanel();
        this.exportDirLabel = new JLabel();
        this.exportDirLabel1 = new JLabel();
        this.exportDirLabel2 = new JLabel();
        this.exportDirLabel3 = new JLabel();
        this.exportDirLabel4 = new JLabel();
        this.exportDirLabel5 = new JLabel();
        this.exportDirText = new JTextField();
        this.exportDirSelButton = new JButton();
        this.convSizePanel = new JPanel();
        this.mainImageLabel = new JLabel();
        this.mainLengthLabel = new JLabel();
        this.mainLengthText = new JTextField();
        this.mainMaxWidthLabel = new JLabel();
        this.mainMaxWidthText = new JTextField();
        this.mainMaxHeightLabel = new JLabel();
        this.mainMaxHeightText = new JTextField();
        this.mainQualityLabel = new JLabel();
        this.mainQualityText = new JTextField();
        this.percentLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.indexImageLabel = new JLabel();
        this.indexLengthLabel = new JLabel();
        this.indexLengthText = new JTextField();
        this.indexQualityLabel = new JLabel();
        this.indexQualityText = new JTextField();
        this.percentLabel1 = new JLabel();
        this.convToolPanel1 = new JPanel();
        this.useMagickCheckBox = new JCheckBox();
        this.useMagickDescLabel = new JLabel();
        this.savePanel = new JPanel();
        this.metadataFormatPanel = new JPanel();
        this.saveLabel = new JLabel();
        this.saveTitleLabel = new JLabel();
        this.saveAsXMLCheckBox = new JCheckBox();
        this.saveEncodingLabel = new JLabel();
        this.saveEncodingTextField = new JTextField();
        this.jSeparator3 = new JSeparator();
        this.exportLabel = new JLabel();
        this.exportTitleLabel = new JLabel();
        this.exportAsXmlCheckBox = new JCheckBox();
        this.exportEncodingLabel = new JLabel();
        this.exportEncodingTextField = new JTextField();
        this.jSeparator4 = new JSeparator();
        this.restartLabel = new JLabel();
        this.restartLabel2 = new JLabel();
        this.panelOptionsPanel = new JPanel();
        this.dirTreePanelOptionsPanel = new JPanel();
        this.saveCurrentDirCheckBox = new JCheckBox();
        this.contentsPanelOptionsPanel = new JPanel();
        this.doubleClickOpensDirCheckBox = new JCheckBox();
        this.doubleClickOpensFileCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("Preferences");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SettingsDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.seriesPanel.setOpaque(false);
        this.seriesPanel.setLayout(new GridBagLayout());
        this.listPanel.setBorder(BorderFactory.createTitledBorder("Series Container Directories"));
        this.listPanel.setOpaque(false);
        this.listPanel.setLayout(new GridBagLayout());
        this.titleLabel.setText("A \"series container\" is a directory that contains photo series. A photo series is a directory that");
        this.titleLabel.setMaximumSize(new Dimension(534, 17));
        this.titleLabel.setMinimumSize(new Dimension(534, 17));
        this.titleLabel.setPreferredSize(new Dimension(534, 17));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.listPanel.add((Component)this.titleLabel, gridBagConstraints);
        this.titleLabel1.setText("contains images -- in subdirectories or directly. E.g., if the root of the \"Sao Tome\" series \nis the");
        this.titleLabel1.setMaximumSize(new Dimension(530, 17));
        this.titleLabel1.setMinimumSize(new Dimension(530, 17));
        this.titleLabel1.setPreferredSize(new Dimension(530, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.listPanel.add((Component)this.titleLabel1, gridBagConstraints);
        this.titleLabel2.setText("directory \"C:\\My Photos\\Sao-Tome\", the series container directory is \"C:\\My Photos\".");
        this.titleLabel2.setMaximumSize(new Dimension(478, 17));
        this.titleLabel2.setMinimumSize(new Dimension(478, 17));
        this.titleLabel2.setPreferredSize(new Dimension(478, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.listPanel.add((Component)this.titleLabel2, gridBagConstraints);
        this.sContainerDirList.setVisibleRowCount(6);
        this.jScrollPane1.setViewportView(this.sContainerDirList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(4, 6, 6, 4);
        this.listPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addButton.setText("Add ...");
        this.addButton.setToolTipText("Add directory containing the series directories");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 0, 0, 6);
        this.listPanel.add((Component)this.addButton, gridBagConstraints);
        this.delButton.setText("Remove");
        this.delButton.setToolTipText("Removes the selected directory");
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.delButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 0, 0, 6);
        this.listPanel.add((Component)this.delButton, gridBagConstraints);
        this.moveUpButton.setText("Move Up");
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 6);
        this.listPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setText("Move Down");
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 0, 6, 6);
        this.listPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.seriesPanel.add((Component)this.listPanel, gridBagConstraints);
        this.sTitlePanel.setBorder(BorderFactory.createTitledBorder("Series Structure"));
        this.sTitlePanel.setOpaque(false);
        this.sTitlePanel.setLayout(new GridBagLayout());
        this.jLabel4.setText("Title:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.sTitlePanel.add((Component)this.jLabel4, gridBagConstraints);
        this.sTitleText.setColumns(50);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.sTitlePanel.add((Component)this.sTitleText, gridBagConstraints);
        this.jLabel5.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 0, 4);
        this.sTitlePanel.add((Component)this.jLabel5, gridBagConstraints);
        this.sDescTextArea.setColumns(66);
        this.sDescTextArea.setLineWrap(true);
        this.sDescTextArea.setRows(3);
        this.sDescTextArea.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.sDescTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.sTitlePanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel1.setText("Image Copyright (${year} stands for the year):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.sTitlePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.sCopyrightText.setText("\u00a9 ${year}");
        this.sCopyrightText.setToolTipText("Copyright text to be printed on every exported image (original images are unaffected). Leave empty for no copyright text.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.sTitlePanel.add((Component)this.sCopyrightText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.seriesPanel.add((Component)this.sTitlePanel, gridBagConstraints);
        this.jTabbedPane.addTab("Series", this.seriesPanel);
        this.exportPanel.setOpaque(false);
        this.exportPanel.setLayout(new GridBagLayout());
        this.exportDirPanel.setBorder(BorderFactory.createTitledBorder("Web Export Directory"));
        this.exportDirPanel.setOpaque(false);
        this.exportDirPanel.setLayout(new GridBagLayout());
        this.exportDirLabel.setHorizontalAlignment(2);
        this.exportDirLabel.setText("Export means that the images are prepared to be put on the Web: they are \nscaled and converted");
        this.exportDirLabel.setMaximumSize(new Dimension(543, 17));
        this.exportDirLabel.setMinimumSize(new Dimension(543, 17));
        this.exportDirLabel.setPreferredSize(new Dimension(543, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.exportDirPanel.add((Component)this.exportDirLabel, gridBagConstraints);
        this.exportDirLabel1.setHorizontalAlignment(2);
        this.exportDirLabel1.setText("to JPEG. The original images remain unaffected, exporting always creates image copies. The");
        this.exportDirLabel1.setMaximumSize(new Dimension(524, 17));
        this.exportDirLabel1.setMinimumSize(new Dimension(524, 17));
        this.exportDirLabel1.setPreferredSize(new Dimension(524, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.exportDirPanel.add((Component)this.exportDirLabel1, gridBagConstraints);
        this.exportDirLabel2.setHorizontalAlignment(2);
        this.exportDirLabel2.setText("\"export directory\" is the directory containing copies of the series, where the images are Web-");
        this.exportDirLabel2.setMaximumSize(new Dimension(531, 17));
        this.exportDirLabel2.setMinimumSize(new Dimension(531, 17));
        this.exportDirLabel2.setPreferredSize(new Dimension(531, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.exportDirPanel.add((Component)this.exportDirLabel2, gridBagConstraints);
        this.exportDirLabel3.setHorizontalAlignment(2);
        this.exportDirLabel3.setText("ready. E.g., if the Web images of the \"Sao Tome\" series should be in \n\"C:\\My Web\\phto\\sao-tome\"");
        this.exportDirLabel3.setMaximumSize(new Dimension(542, 17));
        this.exportDirLabel3.setMinimumSize(new Dimension(542, 17));
        this.exportDirLabel3.setPreferredSize(new Dimension(542, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.exportDirPanel.add((Component)this.exportDirLabel3, gridBagConstraints);
        this.exportDirLabel4.setHorizontalAlignment(2);
        this.exportDirLabel4.setText("the export directory is \"C:\\My Web\\phto\".");
        this.exportDirLabel4.setMaximumSize(new Dimension(230, 17));
        this.exportDirLabel4.setMinimumSize(new Dimension(230, 17));
        this.exportDirLabel4.setPreferredSize(new Dimension(230, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.exportDirPanel.add((Component)this.exportDirLabel4, gridBagConstraints);
        this.exportDirLabel5.setText("Web Export Directory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.exportDirPanel.add((Component)this.exportDirLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.exportDirPanel.add((Component)this.exportDirText, gridBagConstraints);
        this.exportDirSelButton.setText("...");
        this.exportDirSelButton.setToolTipText("Select Web export directory");
        this.exportDirSelButton.setMaximumSize(new Dimension(30, 20));
        this.exportDirSelButton.setMinimumSize(new Dimension(30, 20));
        this.exportDirSelButton.setPreferredSize(new Dimension(30, 20));
        this.exportDirSelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.exportDirSelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(6, 4, 6, 6);
        this.exportDirPanel.add((Component)this.exportDirSelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.exportPanel.add((Component)this.exportDirPanel, gridBagConstraints);
        this.convSizePanel.setBorder(BorderFactory.createTitledBorder("Image Conversion"));
        this.convSizePanel.setOpaque(false);
        this.convSizePanel.setLayout(new GridBagLayout());
        this.mainImageLabel.setText("Main Images (each to be shown on its own Web page):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.convSizePanel.add((Component)this.mainImageLabel, gridBagConstraints);
        this.mainLengthLabel.setHorizontalAlignment(4);
        this.mainLengthLabel.setText("Length:");
        this.mainLengthLabel.setMaximumSize(new Dimension(110, 16));
        this.mainLengthLabel.setMinimumSize(new Dimension(110, 16));
        this.mainLengthLabel.setOpaque(false);
        this.mainLengthLabel.setPreferredSize(new Dimension(110, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.convSizePanel.add((Component)this.mainLengthLabel, gridBagConstraints);
        this.mainLengthText.setToolTipText("Main image normal width or height in pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.convSizePanel.add((Component)this.mainLengthText, gridBagConstraints);
        this.mainMaxWidthLabel.setText("Max. Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.convSizePanel.add((Component)this.mainMaxWidthLabel, gridBagConstraints);
        this.mainMaxWidthText.setToolTipText("Maximum main image width in pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.convSizePanel.add((Component)this.mainMaxWidthText, gridBagConstraints);
        this.mainMaxHeightLabel.setHorizontalAlignment(4);
        this.mainMaxHeightLabel.setText("Max. Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.convSizePanel.add((Component)this.mainMaxHeightLabel, gridBagConstraints);
        this.mainMaxHeightText.setToolTipText("Maximum main image height in pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 6);
        this.convSizePanel.add((Component)this.mainMaxHeightText, gridBagConstraints);
        this.mainQualityLabel.setHorizontalAlignment(4);
        this.mainQualityLabel.setText("JPEG Quality:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.convSizePanel.add((Component)this.mainQualityLabel, gridBagConstraints);
        this.mainQualityText.setToolTipText("Main image JPEG compression quality in percent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.convSizePanel.add((Component)this.mainQualityText, gridBagConstraints);
        this.percentLabel.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.convSizePanel.add((Component)this.percentLabel, gridBagConstraints);
        this.jSeparator2.setForeground(new Color(208, 208, 191));
        this.jSeparator2.setMinimumSize(new Dimension(10, 2));
        this.jSeparator2.setPreferredSize(new Dimension(10, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 6, 0, 6);
        this.convSizePanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.indexImageLabel.setText("Overview Images (all of a group to be shown together on an overview [index] page):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.convSizePanel.add((Component)this.indexImageLabel, gridBagConstraints);
        this.indexLengthLabel.setHorizontalAlignment(4);
        this.indexLengthLabel.setText("Max. Size:");
        this.indexLengthLabel.setMaximumSize(new Dimension(110, 16));
        this.indexLengthLabel.setMinimumSize(new Dimension(110, 16));
        this.indexLengthLabel.setPreferredSize(new Dimension(110, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.convSizePanel.add((Component)this.indexLengthLabel, gridBagConstraints);
        this.indexLengthText.setToolTipText("Normal overview image width in pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.convSizePanel.add((Component)this.indexLengthText, gridBagConstraints);
        this.indexQualityLabel.setHorizontalAlignment(4);
        this.indexQualityLabel.setText("JPEG Quality:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.convSizePanel.add((Component)this.indexQualityLabel, gridBagConstraints);
        this.indexQualityText.setToolTipText("Overview image JPEG compression quality in percent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 4, 6, 0);
        this.convSizePanel.add((Component)this.indexQualityText, gridBagConstraints);
        this.percentLabel1.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.convSizePanel.add((Component)this.percentLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.exportPanel.add((Component)this.convSizePanel, gridBagConstraints);
        this.convToolPanel1.setBorder(BorderFactory.createTitledBorder("Conversion Tool"));
        this.convToolPanel1.setOpaque(false);
        this.convToolPanel1.setLayout(new GridBagLayout());
        this.useMagickCheckBox.setText("Use ImageMagick");
        this.useMagickCheckBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.convToolPanel1.add((Component)this.useMagickCheckBox, gridBagConstraints);
        this.useMagickDescLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.convToolPanel1.add((Component)this.useMagickDescLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.exportPanel.add((Component)this.convToolPanel1, gridBagConstraints);
        this.jTabbedPane.addTab("Web Export", this.exportPanel);
        this.savePanel.setOpaque(false);
        this.savePanel.setLayout(new GridBagLayout());
        this.metadataFormatPanel.setBorder(BorderFactory.createTitledBorder("Metadata Format"));
        this.metadataFormatPanel.setOpaque(false);
        this.metadataFormatPanel.setLayout(new GridBagLayout());
        this.saveLabel.setForeground(new Color(0, 70, 213));
        this.saveLabel.setText("Series Metadata");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.metadataFormatPanel.add((Component)this.saveLabel, gridBagConstraints);
        this.saveTitleLabel.setText("Check to save the series metadata as XML, uncheck to save as text.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.metadataFormatPanel.add((Component)this.saveTitleLabel, gridBagConstraints);
        this.saveAsXMLCheckBox.setText("Save as XML");
        this.saveAsXMLCheckBox.setToolTipText("Check to save the series metadata as XML, uncheck to save as text");
        this.saveAsXMLCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveAsXMLCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.saveAsXMLCheckBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 8, 0, 0);
        this.metadataFormatPanel.add((Component)this.saveAsXMLCheckBox, gridBagConstraints);
        this.saveEncodingLabel.setText("Character Encoding:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.metadataFormatPanel.add((Component)this.saveEncodingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 6);
        this.metadataFormatPanel.add((Component)this.saveEncodingTextField, gridBagConstraints);
        this.jSeparator3.setForeground(new Color(208, 208, 191));
        this.jSeparator3.setMinimumSize(new Dimension(10, 2));
        this.jSeparator3.setPreferredSize(new Dimension(10, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 8);
        this.metadataFormatPanel.add((Component)this.jSeparator3, gridBagConstraints);
        this.exportLabel.setForeground(new Color(0, 70, 213));
        this.exportLabel.setText("Web-Exported Metadata");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 6, 0, 0);
        this.metadataFormatPanel.add((Component)this.exportLabel, gridBagConstraints);
        this.exportTitleLabel.setText("Check to export the series metadata as XML, uncheck to export as text.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.metadataFormatPanel.add((Component)this.exportTitleLabel, gridBagConstraints);
        this.exportAsXmlCheckBox.setText("Export as XML");
        this.exportAsXmlCheckBox.setToolTipText("Check to export the series metadata as XML, uncheck to export as text");
        this.exportAsXmlCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.exportAsXmlCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.exportAsXmlCheckBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 8, 0, 0);
        this.metadataFormatPanel.add((Component)this.exportAsXmlCheckBox, gridBagConstraints);
        this.exportEncodingLabel.setText("Character Encoding:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.metadataFormatPanel.add((Component)this.exportEncodingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 6);
        this.metadataFormatPanel.add((Component)this.exportEncodingTextField, gridBagConstraints);
        this.jSeparator4.setForeground(new Color(208, 208, 191));
        this.jSeparator4.setMinimumSize(new Dimension(10, 2));
        this.jSeparator4.setPreferredSize(new Dimension(10, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 8);
        this.metadataFormatPanel.add((Component)this.jSeparator4, gridBagConstraints);
        this.restartLabel.setForeground(new Color(0, 70, 213));
        this.restartLabel.setText("These settings take effect after a restart of JPhoto-Explorer.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(10, 6, 0, 0);
        this.metadataFormatPanel.add((Component)this.restartLabel, gridBagConstraints);
        this.restartLabel2.setText("Consider backing up your series metadata files before restarting.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(2, 6, 4, 0);
        this.metadataFormatPanel.add((Component)this.restartLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.savePanel.add((Component)this.metadataFormatPanel, gridBagConstraints);
        this.jTabbedPane.addTab("Save", this.savePanel);
        this.panelOptionsPanel.setOpaque(false);
        this.panelOptionsPanel.setLayout(new GridBagLayout());
        this.dirTreePanelOptionsPanel.setBorder(BorderFactory.createTitledBorder("Directory Tree Panel"));
        this.dirTreePanelOptionsPanel.setOpaque(false);
        this.dirTreePanelOptionsPanel.setLayout(new GridBagLayout());
        this.saveCurrentDirCheckBox.setText("Restore current directory selection on startup");
        this.saveCurrentDirCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveCurrentDirCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.saveCurrentDirCheckBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(2, 6, 3, 0);
        this.dirTreePanelOptionsPanel.add((Component)this.saveCurrentDirCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.panelOptionsPanel.add((Component)this.dirTreePanelOptionsPanel, gridBagConstraints);
        this.contentsPanelOptionsPanel.setBorder(BorderFactory.createTitledBorder(" Contents Panel"));
        this.contentsPanelOptionsPanel.setOpaque(false);
        this.contentsPanelOptionsPanel.setLayout(new GridBagLayout());
        this.doubleClickOpensDirCheckBox.setText("Double click on directory opens");
        this.doubleClickOpensDirCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.doubleClickOpensDirCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.doubleClickOpensDirCheckBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        this.contentsPanelOptionsPanel.add((Component)this.doubleClickOpensDirCheckBox, gridBagConstraints);
        this.doubleClickOpensFileCheckBox.setText("Double click on file opens");
        this.doubleClickOpensFileCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.doubleClickOpensFileCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.doubleClickOpensFileCheckBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 4, 0);
        this.contentsPanelOptionsPanel.add((Component)this.doubleClickOpensFileCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panelOptionsPanel.add((Component)this.contentsPanelOptionsPanel, gridBagConstraints);
        this.jTabbedPane.addTab("Panel Options", this.panelOptionsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.jTabbedPane, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 3, 6);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void exportDirSelButtonActionPerformed(ActionEvent evt) {
        File dirFile;
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Select Web Export Directory");
        choose.setDialogType(0);
        choose.setFileSelectionMode(1);
        choose.setApproveButtonToolTipText("Select as root directory for the Web export of all series");
        String dir = this.exportDirText.getText();
        if (dir != null && dir.length() > 0) {
            dirFile = new File(dir);
            if ((dirFile = dirFile.getParentFile()).isDirectory()) {
                choose.setCurrentDirectory(dirFile);
            }
        }
        if (choose.showDialog(this, "Select") != 0) {
            return;
        }
        dirFile = choose.getSelectedFile();
        if (dirFile == null || !dirFile.isDirectory()) {
            return;
        }
        dir = dirFile.getAbsolutePath();
        this.exportDirText.setText(dir);
    }

    private void delButtonActionPerformed(ActionEvent evt) {
        int index = this.sContainerDirList.getSelectedIndex();
        if (index < 0 || index >= this.m_seriesContainerNames.size()) {
            return;
        }
        this.m_seriesContainerNames.removeElementAt(index);
        this.sContainerDirList.setListData(this.m_seriesContainerNames);
        this.m_currentSContainerDir = null;
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        int index = this.sContainerDirList.getSelectedIndex();
        if (index < 0 || index >= this.m_seriesContainerNames.size() - 1) {
            return;
        }
        String th = this.m_seriesContainerNames.get(index);
        String nx = this.m_seriesContainerNames.get(index + 1);
        this.m_seriesContainerNames.setElementAt(th, index + 1);
        this.m_seriesContainerNames.setElementAt(nx, index);
        this.sContainerDirList.setListData(this.m_seriesContainerNames);
        this.sContainerDirList.setSelectedIndex(index + 1);
        this.m_currentSContainerDir = null;
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int index = this.sContainerDirList.getSelectedIndex();
        if (index <= 0 || index >= this.m_seriesContainerNames.size()) {
            return;
        }
        String th = this.m_seriesContainerNames.get(index);
        String nx = this.m_seriesContainerNames.get(index - 1);
        this.m_seriesContainerNames.setElementAt(th, index - 1);
        this.m_seriesContainerNames.setElementAt(nx, index);
        this.sContainerDirList.setListData(this.m_seriesContainerNames);
        this.sContainerDirList.setSelectedIndex(index - 1);
        this.m_currentSContainerDir = null;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.m_seriesContainerNames.size() == 0) {
            JOptionPane.showMessageDialog(this, "Please select at least one series container directory", "J Photo-Explorer", 2);
            this.jTabbedPane.setSelectedIndex(0);
            this.addButton.requestFocus();
            return;
        }
        String exportDir = this.exportDirText.getText();
        File f = new File(exportDir);
        if (!f.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Please enter or select a valid Web export directory", "J Photo-Explorer", 2);
            this.jTabbedPane.setSelectedIndex(1);
            this.exportDirText.requestFocus();
            return;
        }
        Integer intVal = this.validateInt(this.mainLengthText, "normal width/height", 1, 0, 10000);
        if (intVal == null) {
            return;
        }
        int mainLength = intVal;
        intVal = this.validateInt(this.mainMaxWidthText, "maximum width", 1, 0, 10000);
        if (intVal == null) {
            return;
        }
        int mainMaxWidth = intVal;
        intVal = this.validateInt(this.mainMaxHeightText, "maximum height", 1, 0, 10000);
        if (intVal == null) {
            return;
        }
        int mainMaxHeight = intVal;
        intVal = this.validateInt(this.mainQualityText, "JPEG quality", 1, 0, 100);
        if (intVal == null) {
            return;
        }
        int mainQuality = intVal;
        intVal = this.validateInt(this.indexLengthText, "maximum width/height", 1, 0, 10000);
        if (intVal == null) {
            return;
        }
        int indexLength = intVal;
        intVal = this.validateInt(this.indexQualityText, "JPEG quality", 1, 0, 100);
        if (intVal == null) {
            return;
        }
        int indexQuality = intVal;
        this.m_frame.saveSettings();
        String s = this.sTitleText.getText();
        if (s.length() > 0) {
            this.m_settings.set("gallery.title", s);
        }
        if ((s = this.sDescTextArea.getText()).length() > 0) {
            this.m_settings.set("gallery.description", s);
        }
        if ((s = this.sCopyrightText.getText()).length() > 0 && !"\u00a9 ${year}".equals(s)) {
            this.m_settings.set("gallery.copyright", s);
        }
        this.m_settings.set("export.dir", exportDir);
        this.m_settings.setInt("export.mainimg.length", mainLength);
        this.m_settings.setInt("export.mainimg.max_width", mainMaxWidth);
        this.m_settings.setInt("export.mainimg.max_height", mainMaxHeight);
        this.m_settings.setInt("export.mainimg.quality", mainQuality);
        this.m_settings.setInt("export.indeximg.length", indexLength);
        this.m_settings.setInt("export.indeximg.quality", indexQuality);
        if (this.m_bHaveImageMagick) {
            this.m_settings.setInt("export.use_magick", this.useMagickCheckBox.isSelected() ? 1 : 0);
        }
        this.m_settings.setBoolean("metadata.save.xml", this.saveAsXMLCheckBox.isSelected());
        s = this.saveEncodingTextField.getText();
        if (s != null && s.length() > 0 && !s.equalsIgnoreCase("ISO-8859-1")) {
            this.m_settings.set("metadata.save.xml.encoding", s);
        } else {
            this.m_settings.remove("metadata.save.xml.encoding");
        }
        this.m_settings.setBoolean("metadata.export.xml", this.exportAsXmlCheckBox.isSelected());
        s = this.exportEncodingTextField.getText();
        if (s != null && s.length() > 0 && !s.equalsIgnoreCase("ISO-8859-1")) {
            this.m_settings.set("metadata.export.xml.encoding", s);
        } else {
            this.m_settings.remove("metadata.export.xml.encoding");
        }
        this.m_settings.setBoolean("dirtree.save_current_dir_on_exit", this.saveCurrentDirCheckBox.isSelected());
        this.m_settings.setBoolean("contents.dbl_click_on_dir_opens", this.doubleClickOpensDirCheckBox.isSelected());
        this.m_settings.setBoolean("contents.dbl_click_on_file_opens", this.doubleClickOpensFileCheckBox.isSelected());
        try {
            this.m_seriesContainer.mergeSeriesContainers(this.m_seriesContainerNames);
            Iterator<String> iter = this.m_seriesContainerNames.iterator();
            while (iter.hasNext()) {
                this.m_settings.addSeriesContainer(iter.next());
            }
            this.m_settings.save();
        }
        catch (Exception pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "J Photo-Explorer", 0);
            return;
        }
        this.m_frame.reloadSettings();
        this.m_isChanged = true;
        this.cancelButtonActionPerformed(evt);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        File dirFile;
        JFileChooser choose = new JFileChooser();
        choose.setDialogTitle("Select Series Container Directory");
        choose.setDialogType(0);
        choose.setFileSelectionMode(1);
        choose.setApproveButtonToolTipText("Select as Series Container directory");
        String dir = this.m_currentSContainerDir;
        if (dir == null && this.m_seriesContainerNames.size() > 0) {
            dir = this.m_seriesContainerNames.get(0);
        }
        if (dir != null && dir.length() > 0 && (dirFile = new File(dir)).isDirectory()) {
            choose.setCurrentDirectory(dirFile);
        }
        if (choose.showDialog(this, "Select") != 0) {
            return;
        }
        dirFile = choose.getSelectedFile();
        if (dirFile == null || !dirFile.isDirectory()) {
            return;
        }
        dir = dirFile.getAbsolutePath();
        if (!this.m_seriesContainerNames.contains(dir)) {
            this.m_seriesContainerNames.add(dir);
            this.sContainerDirList.setListData(this.m_seriesContainerNames);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

