/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextViewDialog
extends JDialog {
    private JLabel titleLabel;
    private JPanel buttonPanel;
    private JScrollPane textScrollPane;
    private JTextArea contentsTextArea;
    private JButton closeButton;

    public TextViewDialog(Frame parent, String title, String textFilePath, boolean modal) {
        super(parent, modal);
        this.initialize(title, textFilePath);
    }

    public TextViewDialog(Dialog parent, String title, String textFilePath, boolean modal) {
        super(parent, modal);
        this.initialize(title, textFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(String title, String textFilePath) {
        String tit;
        this.initComponents();
        String string = tit = title != null ? title : " ";
        if (tit.length() > 1) {
            tit = tit + " - ";
        }
        tit = tit + "Text View";
        this.setTitle(tit);
        this.titleLabel.setText(textFilePath);
        BufferedReader in = null;
        StringBuffer fileContents = new StringBuffer(10000);
        try {
            String line;
            in = new BufferedReader(new FileReader(textFilePath));
            while ((line = in.readLine()) != null) {
                fileContents.append(line).append('\n');
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Cannot display file \"" + textFilePath + "\"\nError: " + e, "J Photo-Explorer", 0);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {}
        }
        if (fileContents.length() > 0) {
            this.contentsTextArea.setText(fileContents.toString());
            this.contentsTextArea.setCaretPosition(0);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension siz = tk.getScreenSize();
        Rectangle frameRect = new Rectangle();
        frameRect.width = 950;
        if (frameRect.width >= siz.width) {
            frameRect.width = siz.width;
        }
        frameRect.height = siz.height - 34;
        frameRect.x = 0;
        frameRect.y = 0;
        this.setBounds(frameRect);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.textScrollPane = new JScrollPane();
        this.contentsTextArea = new JTextArea();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TextViewDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setText(" ");
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.contentsTextArea.setColumns(40);
        this.contentsTextArea.setFont(new Font("Monospaced", 0, 14));
        this.contentsTextArea.setRows(30);
        this.contentsTextArea.setTabSize(4);
        this.textScrollPane.setViewportView(this.contentsTextArea);
        this.getContentPane().add((Component)this.textScrollPane, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextViewDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

