/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.panel.contents;

import com.dgrossmann.photo.AppInfo;
import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.ui.dialog.ExportedImageViewDialog;
import com.dgrossmann.photo.ui.panel.contents.ContentsPanel;
import com.dgrossmann.photo.webexport.ExportFactory;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ContentsPreviewManager
implements HyperlinkListener {
    public static final String PREVIEW_MAIN_IMAGES = "contents.preview.main_images";
    private static final String TAG_SUB_GROUP_LIST = "<sub-group-list>";
    private static final String TAG_FILE_LIST = "<file-list>";
    private static final int NUM_INDEX_COLS = 3;
    private static final int NUM_MAIN_COLS = 2;
    private ContentsPanel m_parentPanel;
    private JEditorPane m_htmlView;
    private DirectoryObject m_currentDirectory;
    private boolean m_bIsActive;
    private boolean m_bNeedRefresh;
    private boolean m_bShowMainImages;
    private Map<Object, AbstractFSObject> m_imageMap;
    private static final int SHOW_NOTHING = 0;
    private static final int SHOW_SUBDIRS = 1;
    private static final int SHOW_FILES = 2;

    public ContentsPreviewManager(ContentsPanel parentPanel, JEditorPane htmlView) {
        this.m_parentPanel = parentPanel;
        this.m_htmlView = htmlView;
        this.m_currentDirectory = null;
        this.m_bIsActive = false;
        this.m_bNeedRefresh = false;
        this.m_bShowMainImages = false;
        this.m_imageMap = new HashMap<Object, AbstractFSObject>();
        this.m_htmlView.setContentType("text/html");
        this.m_htmlView.setEditable(false);
        this.m_htmlView.addHyperlinkListener(this);
    }

    public void setCurrentDirectory(DirectoryObject currentDir) {
        this.m_currentDirectory = currentDir;
        this.m_bNeedRefresh = true;
        this.refresh();
    }

    public void setActive(boolean bActive) {
        this.m_bIsActive = bActive;
        if (this.m_bIsActive) {
            this.m_bNeedRefresh = true;
            this.refresh();
        }
    }

    public void refresh() {
        if (!this.m_bIsActive || !this.m_bNeedRefresh) {
            return;
        }
        this.m_bNeedRefresh = false;
        if (this.m_currentDirectory == null) {
            this.m_htmlView.setText(this.showOff());
            this.m_htmlView.select(0, -1);
            return;
        }
        URL styleSheetURL = this.getClass().getClassLoader().getResource("images/styles.css");
        StringBuffer html = new StringBuffer(10000);
        html.append("<html><head><title>HTML Preview</title>\n");
        if (styleSheetURL != null) {
            html.append("<link rel='stylesheet' type='text/css' href='").append(styleSheetURL.toExternalForm()).append("'>\n");
        }
        html.append("</head>\n").append("<body>\n");
        html.append("<h1><font color='#999999'>Contents of ");
        if (this.m_currentDirectory.getParent() == null) {
            html.append("series");
        } else {
            html.append("group");
        }
        html.append("</font> <font color='#D32C58'>").append(this.m_currentDirectory.getTitle(true)).append("</font></h1>\n");
        boolean bHaveExportedFiles = false;
        Iterator<FileObject> iter = this.m_currentDirectory.getFileIterator();
        while (iter.hasNext()) {
            FileObject fileObj = iter.next();
            if (!fileObj.isToExport()) continue;
            bHaveExportedFiles = true;
            break;
        }
        if (bHaveExportedFiles) {
            html.append("<p><font color='#999999'>");
            if (this.m_bShowMainImages) {
                html.append("The following shows all main images.</font>").append(" <a href='#index'><b>Show index images</b>.</a>");
            } else {
                html.append("The following shows all index images.</font>").append(" <a href='#main'><b>Show main images</b>.</a>");
            }
            html.append("</p>\n");
        }
        this.m_imageMap.clear();
        if (this.showDirOverview(html)) {
            this.showAllFiles(html);
        }
        if (!bHaveExportedFiles) {
            html.append("<p>&nbsp;</p><h2><font color='#999999'>There are ").append("no exported files in this group.</font></h2>\n");
        }
        html.append("</body></html>");
        this.m_htmlView.setText(html.toString());
        this.m_htmlView.select(0, -1);
    }

    private boolean showDirOverview(StringBuffer html) {
        if (this.m_currentDirectory == null) {
            return false;
        }
        boolean bShowFiles = true;
        boolean bShowSubDirs = true;
        String desc = this.m_currentDirectory.get("description");
        if (desc != null && desc.length() > 0) {
            String descBegin;
            String descEnd = "";
            String descMiddle = "";
            int secondOp = 0;
            int firstOp = 0;
            desc = this.processImgElements(desc);
            int posSubGroups = desc.indexOf(TAG_SUB_GROUP_LIST);
            int posFiles = desc.indexOf(TAG_FILE_LIST);
            if (posSubGroups < 0 && posFiles < 0) {
                descBegin = desc;
            } else if (posFiles < 0) {
                descBegin = desc.substring(0, posSubGroups).trim();
                descMiddle = desc.substring(posSubGroups + TAG_SUB_GROUP_LIST.length());
                firstOp = 1;
            } else if (posSubGroups < 0) {
                descBegin = desc.substring(0, posFiles).trim();
                descMiddle = desc.substring(posFiles + TAG_FILE_LIST.length()).trim();
                firstOp = 2;
            } else {
                int len2;
                int pos2;
                int len1;
                int pos1;
                if (posSubGroups < posFiles) {
                    pos1 = posSubGroups;
                    len1 = TAG_SUB_GROUP_LIST.length();
                    pos2 = posFiles;
                    len2 = TAG_FILE_LIST.length();
                    firstOp = 1;
                    secondOp = 2;
                } else {
                    pos2 = posSubGroups;
                    len2 = TAG_SUB_GROUP_LIST.length();
                    pos1 = posFiles;
                    len1 = TAG_FILE_LIST.length();
                    firstOp = 2;
                    secondOp = 1;
                }
                descBegin = desc.substring(0, pos1).trim();
                descMiddle = desc.substring(pos1 + len1, pos2 - pos1 - len1).trim();
                descEnd = desc.substring(pos2 + len2).trim();
            }
            String repl = "</p>\n<p>";
            html.append("<p>");
            html.append(descBegin.replaceAll("\n\n", repl)).append("\n");
            if (firstOp == 1) {
                this.showAllSubDirectories(false, html);
                bShowSubDirs = false;
            } else if (firstOp == 2) {
                this.showAllFiles(html);
                bShowFiles = false;
            }
            if (descMiddle.length() > 0) {
                html.append(descMiddle.replaceAll("\n\n", repl)).append("\n");
            }
            if (secondOp == 1) {
                this.showAllSubDirectories(false, html);
                bShowSubDirs = false;
            } else if (secondOp == 2) {
                this.showAllFiles(html);
                bShowFiles = false;
            }
            if (descEnd.length() > 0) {
                html.append(descEnd.replaceAll("\n\n", repl)).append("\n");
            }
            html.append("</p>\n");
        }
        if (bShowSubDirs) {
            this.showAllSubDirectories(true, html);
        }
        return bShowFiles;
    }

    private String processImgElements(String descStr) {
        int index;
        URL exportDirUrl;
        try {
            exportDirUrl = new File(this.m_parentPanel.getFrame().getSettings().get("export.dir")).toURI().toURL();
        }
        catch (Exception exc) {
            return descStr;
        }
        StringBuffer sb = new StringBuffer(descStr.length() + 222);
        int i = 0;
        while ((index = descStr.indexOf("src=", i)) >= 0) {
            sb.append(descStr.substring(i, index += 4));
            for (i = index; i < descStr.length() && (descStr.charAt(i) == ' ' || descStr.charAt(i) == '\t'); ++i) {
            }
            sb.append(descStr.charAt(i++));
            if (descStr.charAt(i) == '/') continue;
            sb.append(exportDirUrl.toExternalForm()).append('/');
        }
        if (i == 0) {
            return descStr;
        }
        sb.append(descStr.substring(i));
        return sb.toString();
    }

    private void showAllSubDirectories(boolean bWithHeading, StringBuffer html) {
        if (this.m_currentDirectory == null || this.m_currentDirectory.getSubDirCount() == 0) {
            return;
        }
        boolean bHaveDir = false;
        URL arrowURL = this.getClass().getClassLoader().getResource("images/nav-arrow.gif");
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<p>\n");
        Iterator<DirectoryObject> iter = this.m_currentDirectory.getSubDirIterator();
        while (iter.hasNext()) {
            DirectoryObject dirObj = iter.next();
            if (!dirObj.isToExport()) continue;
            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='").append(arrowURL.toExternalForm()).append("'>");
            String link = "#dir:" + dirObj.getFileName();
            this.m_imageMap.put(link, dirObj);
            sb.append("&nbsp;&nbsp;<a href='").append(link).append("'><b>").append(dirObj.getTitle(true)).append("</b></a><br>\n");
            bHaveDir = true;
        }
        sb.append("</p>\n");
        if (bHaveDir) {
            if (bWithHeading) {
                html.append("<h2>Sub Groups</h2>\n");
            }
            html.append(sb);
        }
    }

    private void showAllFiles(StringBuffer html) {
        int i = 0;
        boolean bIsFirstRow = true;
        boolean bNewRowBefore = false;
        int numColumns = this.m_bShowMainImages ? (this.m_htmlView.getWidth() >= 1000 ? 2 : 1) : 3;
        html.append("<table border='0' cellpadding='8' cellspacing='8'>\n");
        Iterator<FileObject> iter = this.m_currentDirectory.getFileIterator();
        while (iter.hasNext()) {
            String tag;
            FileObject fileObj = iter.next();
            if (!fileObj.isToExport()) continue;
            if ((fileObj.isSeparator() || fileObj.isReference()) && i % numColumns != 0) {
                bNewRowBefore = true;
                if (!bIsFirstRow) {
                    html.append(" </tr>\n");
                }
            }
            try {
                tag = this.showOneFile(fileObj);
            }
            catch (Exception exc) {
                tag = exc.toString();
            }
            if (bIsFirstRow || bNewRowBefore || i % numColumns == 0) {
                html.append(" <tr>\n");
                bNewRowBefore = false;
            }
            if (fileObj.isReference()) {
                html.append("  <td colspan='" + numColumns + "'>" + tag + "</td>\n");
            } else {
                html.append("  <td width='33%' valign='bottom' nowrap>" + tag + "</td>\n");
            }
            ++i;
            if (fileObj.isReference()) {
                i = numColumns;
            }
            if (i % numColumns == 0 || !iter.hasNext()) {
                html.append(" </tr>\n");
            }
            bIsFirstRow = false;
        }
        html.append("</table>\n\n");
    }

    private String showOneFile(FileObject fileObj) throws Exception {
        long len;
        if (fileObj.isSeparator()) {
            return "<hr noshade size='1' width='22%' color='#666666'>";
        }
        if (fileObj.isReference()) {
            String tag = "<p>";
            if (fileObj.get("href").length() > 0) {
                tag = tag + "<a href='" + fileObj.get("href") + "'><b>" + fileObj.getTitle(true) + "</b></a><br>\n";
            }
            return tag + fileObj.get("description") + "</p>\n";
        }
        if (fileObj.getFileType() != 1) {
            return "<p><b>" + fileObj.getTitle(true) + "</b><br>\n" + fileObj.get("description") + "</p>\n";
        }
        File[] exportedFiles = ExportFactory.getExport(this.m_parentPanel.getFrame().getSettings(), this.m_parentPanel.getFrame().getSeriesContainer(), this.m_parentPanel).getExportedFiles(fileObj);
        if (exportedFiles == null || exportedFiles.length < 2 || exportedFiles[0] == null || exportedFiles[1] == null) {
            return "<p><b>" + fileObj.getTitle(true) + "</b><br>There are no exported files.</p>\n";
        }
        URL mainFileUrl = exportedFiles[0].toURI().toURL();
        URL indexFileUrl = this.m_bShowMainImages ? mainFileUrl : exportedFiles[1].toURI().toURL();
        this.m_imageMap.put(mainFileUrl, fileObj);
        String indexSize = "--";
        String mainSize = "--";
        if (exportedFiles[0] != null && (len = exportedFiles[0].length() / 1024L) > 0L) {
            mainSize = Long.toString(len) + " KB";
        }
        if (exportedFiles[1] != null && (len = exportedFiles[1].length() / 1024L) > 0L) {
            indexSize = Long.toString(len) + " KB";
        }
        return "<a href='" + mainFileUrl.toExternalForm() + "'><img src='" + indexFileUrl.toExternalForm() + "' border='0'></a><br>\n" + "<a href='" + mainFileUrl.toExternalForm() + "'><b>" + fileObj.getTitle(true) + "</b></a>" + (this.m_bShowMainImages ? " &nbsp; " : "<br>") + "(Main: " + mainSize + ", Index: " + indexSize + ")\n";
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String desc = e.getDescription();
        if ("#main".equals(desc)) {
            this.m_bShowMainImages = true;
            this.m_bNeedRefresh = true;
            this.refresh();
            return;
        }
        if ("#index".equals(desc)) {
            this.m_bShowMainImages = false;
            this.m_bNeedRefresh = true;
            this.refresh();
            return;
        }
        if (desc != null && desc.startsWith("#dir:")) {
            DirectoryObject dirObj = (DirectoryObject)this.m_imageMap.get(desc);
            if (dirObj != null) {
                this.m_parentPanel.fireCurrentDirectoryChanged(dirObj);
            }
            return;
        }
        FileObject fileObj = (FileObject)this.m_imageMap.get(e.getURL());
        if (fileObj == null) {
            JOptionPane.showMessageDialog(this.m_parentPanel, "J Photo-Explorer cannot follow this link:\n" + desc, "J Photo-Explorer", 2);
            return;
        }
        ExportedImageViewDialog dlg = new ExportedImageViewDialog(fileObj, this.m_parentPanel.getFrame().getSettings(), this.m_parentPanel.getFrame().getSeriesContainer(), this.m_parentPanel.getFrame(), true);
        dlg.setVisible(true);
    }

    public void loadSettings(Settings settings) {
        this.m_bShowMainImages = settings.getBoolean(PREVIEW_MAIN_IMAGES, false);
        this.m_bNeedRefresh = true;
    }

    public void saveSettings(Settings settings) {
        settings.setBoolean(PREVIEW_MAIN_IMAGES, this.m_bShowMainImages);
    }

    private String showOff() {
        StringBuffer html = new StringBuffer(900);
        URL styleSheetURL = this.getClass().getClassLoader().getResource("images/styles.css");
        URL appLogoURL = this.getClass().getClassLoader().getResource("images/jp-logo.jpg");
        html = new StringBuffer(10000);
        html.append("<html><head><title>HTML Preview</title>\n");
        if (styleSheetURL != null) {
            html.append("<link rel='stylesheet' type='text/css' href='").append(styleSheetURL.toExternalForm()).append("'>\n");
        }
        html.append("</head>\n").append("<body>\n");
        html.append("<table border='0' cellpadding='0' cellspacing='0' ").append("width='95%'>\n<tr><td height='95%' align='center'>\n");
        html.append("<table border='0' cellpadding='0' cellspacing='0'>\n").append("<tr><td height='95%'>\n");
        html.append("<p></p>\n");
        html.append("<h1>").append("J Photo-Explorer").append("</h1>\n");
        html.append("<p><b>Version ").append(AppInfo.getVersionString()).append("</b><br>").append(AppInfo.getBuildDate(false)).append("</b></p>");
        if (appLogoURL != null) {
            html.append("<p><img src='").append(appLogoURL.toExternalForm()).append("'></p>\n");
        }
        html.append("<p>Copyright \u00a9 ").append(2014).append(" by Dirk S. Grossmann</p>");
        html.append("</td></tr>\n</table>");
        html.append("</td></tr>\n</table>");
        html.append("</body>\n</html>");
        return html.toString();
    }
}

