/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.panel.contents;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.ui.ImageHolder;
import com.dgrossmann.photo.ui.panel.DirTreeModel;
import com.dgrossmann.photo.ui.panel.contents.ContentsPanel;
import com.dgrossmann.photo.ui.panel.contents.ImageTimerTask;
import com.dgrossmann.photo.webexport.ExportException;
import com.dgrossmann.photo.webexport.ExportFactory;
import java.awt.Component;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ContentsTableModel
extends AbstractTableModel {
    private static final String[] s_columnNames = new String[]{"Image", "Name", "Title", "Modified", "Export"};
    private static final Class<?>[] s_columnTypes = new Class[]{ImageIcon.class, String.class, String.class, String.class, Boolean.class};
    public Component m_parentComponent;
    public ContentsPanel m_parentPanel;
    public Timer m_timer;
    protected JTree m_dirTree;
    protected DirTreeModel m_dirTreeModel;
    protected ImageHolder m_imgHolder;
    protected DirectoryObject m_currentDir = null;
    protected boolean m_bWithImagePreview;

    public ContentsTableModel(Component parent, ContentsPanel frame, ImageHolder imgHolder) {
        this.m_parentComponent = parent;
        this.m_parentPanel = frame;
        this.m_imgHolder = imgHolder;
        this.m_dirTree = null;
        this.m_dirTreeModel = null;
        this.m_bWithImagePreview = true;
        this.m_timer = null;
    }

    public void setDirTree(JTree dirTree) {
        this.m_dirTree = dirTree;
        this.m_dirTreeModel = this.m_dirTree != null ? (DirTreeModel)this.m_dirTree.getModel() : null;
    }

    public void setCurrentDir(DirectoryObject currentDir) {
        this.m_currentDir = currentDir;
        this.m_imgHolder.stopBackgroundImageLoading();
        if (this.m_timer != null) {
            this.m_timer.stop();
        }
        TableModelEvent evt = new TableModelEvent(this);
        this.fireTableChanged(evt);
    }

    public void refresh() {
        TableModelEvent evt = new TableModelEvent(this);
        this.fireTableChanged(evt);
    }

    @Override
    public int getColumnCount() {
        return s_columnNames.length;
    }

    @Override
    public String getColumnName(int index) {
        return s_columnNames[index];
    }

    @Override
    public Class<?> getColumnClass(int index) {
        return s_columnTypes[index];
    }

    public ImageIcon getTypeImage(AbstractFSObject fsObj) {
        ImageIcon icon = this.m_imgHolder.getTypeImage(fsObj, this.m_bWithImagePreview, "list", 50, this.m_parentComponent, false);
        if (this.m_bWithImagePreview && !this.m_imgHolder.hasAllImages()) {
            if (this.m_timer == null) {
                this.m_timer = new Timer(1000, new ImageTimerTask(this, this.m_imgHolder));
                this.m_timer.start();
            } else if (!this.m_timer.isRunning()) {
                this.m_timer.start();
            }
        }
        return icon;
    }

    @Override
    public int getRowCount() {
        return this.m_currentDir != null ? this.m_currentDir.getSubDirCount() + this.m_currentDir.getFileCount() : 0;
    }

    public AbstractFSObject getFSObjectAt(int rowIndex) {
        if (this.m_currentDir == null || rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        int dirCount = this.m_currentDir.getSubDirCount();
        if (rowIndex < dirCount) {
            return this.m_currentDir.getSubDirAt(rowIndex);
        }
        return this.m_currentDir.getFileAt(rowIndex - dirCount);
    }

    public int getIndexOfFSObject(AbstractFSObject fsObj) {
        if (this.m_currentDir == null) {
            return -1;
        }
        if (fsObj instanceof DirectoryObject) {
            return this.m_currentDir.getIndexOfSubDir((DirectoryObject)fsObj);
        }
        if (fsObj instanceof FileObject) {
            int index = this.m_currentDir.getIndexOfFile((FileObject)fsObj);
            if (index >= 0) {
                return index + this.m_currentDir.getSubDirCount();
            }
            return -1;
        }
        return -1;
    }

    public boolean addFSObject(AbstractFSObject fsObj, int rowIndex) {
        if (this.m_currentDir == null) {
            return false;
        }
        if (fsObj instanceof FileObject) {
            rowIndex -= this.m_currentDir.getSubDirCount();
        }
        this.m_currentDir.addChild(fsObj, rowIndex);
        this.refresh();
        return true;
    }

    public boolean removeFSObject(AbstractFSObject fsObj) {
        if (this.m_currentDir == null) {
            return false;
        }
        if (fsObj instanceof FileObject) {
            this.m_currentDir.removeFile((FileObject)fsObj);
            this.refresh();
            return true;
        }
        if (fsObj instanceof DirectoryObject) {
            this.m_currentDir.removeSubDir((DirectoryObject)fsObj);
            if (this.m_dirTreeModel != null) {
                this.m_dirTreeModel.fireTreeStructureChanged(this.m_currentDir);
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column < 0 || column >= this.getColumnCount()) {
            return "";
        }
        AbstractFSObject fsObj = this.getFSObjectAt(row);
        if (fsObj == null) {
            return "";
        }
        switch (column) {
            case 0: {
                return this.getTypeImage(fsObj);
            }
            case 1: {
                return fsObj.getFileName();
            }
            case 2: {
                if (fsObj instanceof FileObject && ((FileObject)fsObj).isSeparator()) {
                    return "-------------------------------";
                }
                return AbstractFSObject.transformAccents(fsObj.getTitle(true), false);
            }
            case 3: {
                return fsObj.getModDateTimeString(true);
            }
            case 4: {
                return new Boolean(fsObj.isToExport());
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.m_currentDir == null || row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        AbstractFSObject fsObj = this.getFSObjectAt(row);
        if (fsObj == null) {
            return false;
        }
        if (fsObj instanceof FileObject && ((FileObject)fsObj).isSeparator()) {
            return column == 4;
        }
        if (fsObj.isReference() && column == 1) {
            return false;
        }
        return column != 0 && column != 3;
    }

    @Override
    public void setValueAt(Object newVal, int row, int column) {
        if (column < 0 || column >= this.getColumnCount() || newVal == null) {
            return;
        }
        AbstractFSObject fsObj = this.getFSObjectAt(row);
        if (fsObj == null) {
            return;
        }
        String str = newVal.toString().trim();
        switch (column) {
            case 1: {
                File f;
                if (fsObj.isReference() || fsObj.getFileName().equalsIgnoreCase(str)) {
                    return;
                }
                if (fsObj.getParent() != null && (f = new File(fsObj.getParent().getFullPath(), str)).exists()) {
                    JOptionPane.showMessageDialog(this.m_parentComponent, "Cannot rename as a file with the following name already exists:\n" + f.getAbsolutePath(), "J Photo-Explorer", 2);
                    return;
                }
                if (this.m_parentPanel != null) {
                    this.m_imgHolder.renameThumbnails(fsObj, str);
                    this.m_parentPanel.renameExportedFiles(fsObj, null, str);
                    fsObj.setFileName(str, true);
                }
                if (!(fsObj instanceof DirectoryObject) || this.m_dirTreeModel == null) break;
                this.m_dirTreeModel.fireTreeStructureChanged(this.m_currentDir);
                break;
            }
            case 2: {
                if (fsObj instanceof FileObject && ((FileObject)fsObj).isSeparator()) {
                    return;
                }
                fsObj.set("title", str);
                break;
            }
            case 4: {
                char ch;
                boolean bVal = false;
                if (newVal instanceof Boolean) {
                    bVal = (Boolean)newVal;
                } else if (str.length() > 0 && ((ch = str.toLowerCase().charAt(0)) == 'y' || ch == 't' || ch == '1')) {
                    bVal = true;
                }
                fsObj.setToExport(bVal);
                if (bVal || !(fsObj instanceof FileObject)) break;
                try {
                    ExportFactory.getExport(this.m_parentPanel.getFrame().getSettings(), this.m_parentPanel.getFrame().getSeriesContainer(), this.m_parentPanel).deleteExportedFiles(fsObj, 1);
                    break;
                }
                catch (ExportException ignored) {
                    // empty catch block
                }
            }
        }
        this.m_currentDir.setChanged();
        this.m_parentPanel.firePropertiesChanged(fsObj);
    }
}

