<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<?php
/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2014 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
  Image or image group display page that accepts the following URL parameters:
  "s" Directory name of the photo series (e.g. "New-Caledonia"). This directory
      is an immediate subdirectory of the directory containing this page. The
      series overview HTML file is "series-dir"/index.html. The series directory
      contains a _"series-dir"_metadata.txt image metadata file written by
      JPhoto-Explorer export.
  "g" For group overview pages. Directory name of the group in a series (e.g.
      Noumea); as a subdirectory in the series directory. The images displayed
      for a block overview page are overview image versions  --or--
  "i" For image pages. Base name of the image file or "first" for the first
      image in a group (if i="first" or if there are several images with the
      same name in a series, the "g"roup name must be given).
  To adopt this file to your environment, change the variable initializations.
  The HTML layout of this page is enclosed in <!-- Begin/End Layout --> com-
  ments and can be replaced without affecting the functionality of this page.
-------------------------------------------------------------------------------
  $Id: img.php 186 2011-12-17 15:50:12Z dirk $
===============================================================================
*/

error_reporting(E_ERROR | E_WARNING | E_PARSE);

include 'img-classes.php';

/*
-------------------------------------------------------------------------------
  V a r i a b l e   I n i t i a l i z a t i o n s
===============================================================================
*/

// Index file name. This is used to build a link to the series overview file.
$g_indexHtmlFile = 'index.html';

// Names of the series/group/image to display (set from the URL parameters).
$g_seriesName = $_REQUEST['s'];
$g_groupName  = $_REQUEST['g'];
$g_imageName  = $_REQUEST['i'];

/*
-------------------------------------------------------------------------------
  M a i n   P a g e
===============================================================================
*/

$g_series = & new SeriesObject($g_seriesName);
// Get the group/image to display. Al loast one of them should be non-null.
$groupObj = $fileObj = null;
if (is_string($g_imageName))
{
    if (!strcasecmp($g_imageName, 'first'))
    {
        $groupObj = $g_series->getGroupObj($g_groupName);
        if (is_object($groupObj))
            $fileObj = &$groupObj->firstFile;
        $groupObj = null;
    }
    else
        $fileObj = $g_series->getFileObj($g_imageName, $g_groupName);
}
else
    $groupObj = $g_series->getGroupObj($g_groupName);
// Check for empty objects to display.
if (!is_object($fileObj) && !is_object($groupObj))
{
    echo '<p><b>Error</b>: Cannot find image or group for s=' . $g_seriesName
        . ', g=' . $g_groupName . ', i=' . $g_imageName . "</p>\n";
    //echo "<p><b>This is what I have</b> :-\n"; $g_series->dump(0);
}
// Get the page title.
if (is_object($fileObj))
    $pageTitle = $fileObj->title;
else if (is_object($groupObj))
    $pageTitle = $groupObj->title;
?>
<title><?php echo $pageTitle ?> | <?php echo $g_series->title ?> | Photography</title>
<!-- Begin Layout -->
<link rel="shortcut icon" href="/favicon.ico">
<link rel="stylesheet" type="text/css" href="../styles-photo.css">
<link rel="stylesheet" href="../js/lytebox/lytebox.css" type="text/css" media="screen" />
<script type="text/javascript" src="../js/lytebox/lytebox.js"></script>
<script type="text/javascript" src="../js/jquery.min.js"></script>
<script type="text/javascript" src="../js/tools-main.js"></script>
<script type="text/javascript">
<!--
function MM_preloadImages() {
 var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
 var i,j=d.MM_p.length,a=MM_preloadImages.arguments; for(i=0; i<a.length; i++)
 if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
}
//-->
</script>
</head>

<body bgcolor="black" text="white" topmargin="0" leftmargin="0"
      rightmargin="0" bottommargin="0" marginheight="0" marginwidth="0"
      link="#B0B0FF" alink="#CC9933" vlink="#B0B0FF">

<table width="100%" height="44" border="0" cellspacing="0" cellpadding="0"
       bgcolor="#444342">
 <tr> 
  <td>
   <div style="margin-left: 22px">
	  <a class="mainNavLink" href="../index.html" title="Dirk S. Grossmann's Homepage">HOME</a>
    <a class="mainNavLink" href="../photo/index.php" title="Photography by Dirk S. Grossmann">PHOTOGRAPHY</a>
    <a class="mainNavLink" href="../work/index.html" title="Dirk's Work Interests">WORK</a>
   </div>
  </td>
  <td width="210" nowrap>
   <a href="../index.html" title="Dirk S. Grossmann"><img
      src="../images/site-logo-photo.gif" width="188" height="36" border="0"
      alt="Dirk S. Grossmann" style="margin-right: 22px"></a></td>
 </tr>
</table>

<table width="100%" border="0" cellspacing="0" cellpadding="0">
 <tr>
  <td height="1" bgcolor="#707080">
   <table border="0" cellspacing="0" cellpadding="0"><tr><td></td></tr></table>
  </td>
  <td height="1" bgcolor="#CC6600">
   <table border="0" cellspacing="0" cellpadding="0"><tr><td></td></tr></table>
  </td>
 </tr>
 <tr>
  <td width="80%" nowrap><div class="clsBreadcrumbs" style="margin-left: 22px">
   <a href="../index.html" title="Dirk S. Grossmann's Homepage">Home</a>
   <img src="../images/nav-arrow-w.gif" width="15" height="10">
   <a href="index.php" title="Photography by Dirk S. Grossmann">Photography</a>
   <img src="../images/nav-arrow-w.gif" width="15" height="10">
<!-- End Layout -->
<?php
   echo '   <a href="' . $g_series->fileName . '/' . $g_indexHtmlFile
      . '">' . $g_series->title . "</a>\n";
?>
   <img src="../images/nav-arrow-w.gif" width="15" height="10">
<?php
  // Show the path in the group hierarchy.
  $bread = '';
  $p = &$groupObj;
  if (!is_object($p))
      $p = &$fileObj;
  $p = &$p->parentDir;
  while (is_object($p->parentDir))
  {
      $bread = '  <a href="' . $g_series->getGroupSource($p)
          . '" title="' . $p->title . '">' . $p->title. "</a>\n"
          . '  <img src="../../images/nav-arrow-w.gif" width="15" height="10">'
          . "\n" . $bread;
      $p = &$p->parentDir;
  }
  echo $bread;
  echo '  ' . $pageTitle . "\n";
?>
<!-- Begin Layout -->
   </div></td>
  <td valign="top" width="300" height="10"></td>
 </tr>
</table>

<div class="clsDocumentBodyNoMargin">
<!-- End Layout -->
<?php
  if (is_object($fileObj))
  {
      /*
      -------------------------------------------------------------------------
        D i s p l a y   a   S i n g l e   I m a g e
      =========================================================================
      */
?>
<div style="margin-left: 22px">
  <div style="margin-bottom: 2em">
    <span class="overviewTabActiveText"><?php echo $pageTitle ?></span>
  </div>

  <table border="0" cellspacing="0" cellpadding="0" width="96%">
    <tr> 
      <td width="66%" align="left" valign="bottom">
      <table border="0" cellspacing="1" cellpadding="1" bgcolor="#666666">
        <tr> 
          <td bgcolor="black" style="padding: 2px">
            <?php echo $g_series->getFileTag($fileObj) ?></td>
        </tr>
      </table>
      </td>
      <td width="*">&nbsp;</td>
      <td width="3%" align="right" valign="top" nowrap>
      <div class="photoNavigationCell">
      <table border="0" cellpadding="2" cellspacing="2">
        <!-- 'Previous' link (to previous image/group) -->
        <tr valign="bottom">
          <td width="5%" nowrap>
<?php
      // 'Previous' link to previous image/group.
      $prevFileObj = $fileObj->getPrevNotRef();
      if (is_object($prevFileObj))
      {
          // Link to the previous image.
          echo $g_series->getFileLinkStartTag($prevFileObj)
             . '<img src="../images/index-arrow-up.gif" border="0" '
             . "width='16' height='16'></a>&nbsp;</td>\n"
             . '      <td align="left" nowrap>Image<br>'
             . $g_series->getFileLinkStartTag($prevFileObj)
             . '<b>' . $prevFileObj->title . "</b></a>";
      }
      else if (is_object($fileObj->parentDir->prevInAllGroups))
      {
          // Link to the previous group.
          $prevGroupObj = &$fileObj->parentDir->prevInAllGroups;
          echo $g_series->getGroupLinkStartTag($prevGroupObj)
             . '<img src="../images/index-arrow-up.gif" border="0" '
             . "width='16' height='16'></a>&nbsp;</td>\n"
             . '      <td align="left" nowrap>Group<br>'
             . $g_series->getGroupLinkStartTag($prevGroupObj) . '<b>'
             . $prevGroupObj->title . "</b></a>";
      }
      else
      {
          // Grayed out for the first group of a series.
          echo '<img src="../images/index-arrow-up.gif" border="0" '
             . 'width="16" height="16">&nbsp;</td>'
             . '      <td align="left" nowrap><font color="#999999">Series '
             . 'Begin</font>';
      }
?>
      </td>
     </tr>
     <!-- 'Next' link (to next image/group) -->
     <tr valign="top">
      <td width="5%">
<?php
      // 'Next' link to the next image/group.
      $nextFileObj = $fileObj->getNextNotRef();
      if (is_object($nextFileObj))
      {
          // Link to the next image in the current group.
          echo $g_series->getFileLinkStartTag($nextFileObj)
             . '<img src="../images/index-arrow-down.gif" border="0" '
             . "width='16' height='16'></a>&nbsp;</td>\n"
             . '      <td align="left">Image<br>'
             . $g_series->getFileLinkStartTag($nextFileObj)
             . '<b>' . $nextFileObj->title . '</b></a>';
      }
      else if (is_object($fileObj->parentDir->nextInAllGroups))
      {
          // Link to the next group.
          $nextGroupObj = &$fileObj->parentDir->nextInAllGroups;
          echo $g_series->getGroupLinkStartTag($nextGroupObj)
             . '<img src="../images/index-arrow-down.gif" border="0" '
             . "width='16' height='16'></a>&nbsp;</td>\n"
             . '      <td align="left" nowrap>Group<br>'
             . $g_series->getGroupLinkStartTag($nextGroupObj) . '<b>'
             . $nextGroupObj->title . '</b></a>';
      }
      else
      {
          // Grayed out for the last group of a series.
          echo '<img src="../images/index-arrow-down.gif" border="0" '
             . "width='16' height='16'>&nbsp;</td>\n"
             . '      <td align="left" nowrap><font color="#999999">Series End'
             . '</font>';
      }
?>
      </td>
     </tr>
     <tr>
      <td colspan="2"><hr noshade size="1" color="#444444"></td>
     </tr>
     <!-- 'Top' link (to parent group) -->
     <tr valign="top">
      <td width="5%">
<?php
      $parentTitle = $fileObj->parentDir->title;
      $parentSrc = $g_series->getGroupSource($fileObj->parentDir);
      // Directory icon.
      $linkTitle = "Go to group " . $parentTitle;
      echo '<a href="' . $parentSrc . '" title="' . $linkTitle
         . '"><img src="../images/p-dir.gif" border="0" '
         . "width=\"16\" height=\"14\" alt=\"$linkTitle\"></a>&nbsp;</td>\n"
         . '       <td align="left" nowrap>'
         . 'Group<br><a href="' . $parentSrc . '" title="' . $linkTitle
         . "\"><b>$parentTitle</b></a>";
?>
      </td>
     </tr>
    </table>
    </div>
    </td>
   </tr>
   <tr> 
    <td colspan="3" align="left">
    <div style="margin-top: 0.3em">
<?php
      // Image title.
      if (strlen($fileObj->subtitle) > 0 || strlen($fileObj->description) > 0)
          echo '<b>' . $fileObj->title . '</b>';
      // Image subtitle and description.
      if (strlen($fileObj->subtitle) > 0)
      {
          $firstChar = substr($fileObj->subtitle, 0, 1);
          if ($firstChar >= 'A' && $firstChar <= 'Z')
              echo '. ' . $fileObj->subtitle . '.';
          else
              echo ' ' . $fileObj->subtitle;
      }
      if (strlen($fileObj->description) > 0)
          echo '   <p>' . $fileObj->getDescription('') . "</p>\n";
?>
    </div>
    </td>
   </tr>
  </table>
</div>
<div class="photoNavigationStripe">    
  <table width="96%" border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td nowrap>
<?php
      // 'Previous' link to previous image/group.
      $prevFileObj = $fileObj->getPrevNotRef();
      if (is_object($prevFileObj))
      {
          // Link to the previous image.
          echo $g_series->getFileLinkStartTag($prevFileObj)
             . '<img src="../images/index-arrow-left.gif" border="0" '
             . "width='16' height='16'></a>&nbsp;"
             . $g_series->getFileLinkStartTag($prevFileObj)
             . '<b>Previous Image</b></a>';
      }
      else if (is_object($fileObj->parentDir->prevInAllGroups))
      {
          // Link to the previous group.
          $prevGroupObj = &$fileObj->parentDir->prevInAllGroups;
          echo $g_series->getGroupLinkStartTag($prevGroupObj)
             . '<img src="../images/index-arrow-left.gif" border="0" '
             . "width='16' height='16'></a>&nbsp;"
             . $g_series->getGroupLinkStartTag($prevGroupObj)
             . '<b>Previous Group</b></a>';
      }
      else
      {
          // Grayed out for the first group of a series.
          echo '<img src="../images/index-arrow-left.gif" border="0" '
             . 'width="16" height="16">&nbsp;<font color="#999999">'
             . 'Series Begin</font>';
      }
?>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<?php
      // 'Next' link to the next image/group.
      $nextFileObj = $fileObj->getNextNotRef();
      if (is_object($nextFileObj))
      {
          // Link to the next image in the current group.
          echo $g_series->getFileLinkStartTag($nextFileObj)
             . '<b>Next Image</b></a>&nbsp;'
             . $g_series->getFileLinkStartTag($nextFileObj)
             . '<img src="../images/index-arrow-right.gif" border="0" '
             . 'width="16" height="16"></a>';
      }
      else if (is_object($fileObj->parentDir->nextInAllGroups))
      {
          // Link to the next group.
          $nextGroupObj = &$fileObj->parentDir->nextInAllGroups;
          echo $g_series->getGroupLinkStartTag($nextGroupObj)
             . '<b>Next Group</b></a>&nbsp;'
             . $g_series->getGroupLinkStartTag($nextGroupObj)
             . '<img src="../images/index-arrow-right.gif" border="0" '
             . 'width="16" height="16"></a>';
      }
      else
      {
          // Grayed out for the last group of a series.
          echo '<font color="#999999">Series End</font>&nbsp;'
             . '<img src="../images/index-arrow-right.gif" border="0" '
             . 'width="16" height="16">';
      }
?>
    </td>
      <td align="right" nowrap width="*">
        <span class="imageCopyright">
          <a href="copyright.html">&copy;
            <?php
              if (is_object($fileObj) && is_object($fileObj->parentDir))
                  echo $fileObj->getYear(GET_BEGIN_DATE);
              else if (is_object($groupObj))
                  echo $groupObj->getYear(GET_BEGIN_DATE);
              else
                  echo $g_series->getYear(GET_BEGIN_DATE);
            ?>
            Dirk S. Grossmann</a>
        </span>
      </td>
    </tr>
  </table>
</div>
<?php
      // Preload the next image in the current group (if available).
      $nextFileObj = $fileObj->getNextNotRef();
      if (is_object($nextFileObj))
      {
          echo "\n<script language=\"JavaScript\">\nMM_preloadImages(\""
             . $nextFileObj->getPath() . "\")\n</script>\n";
      }
  }
  else
  {
      /*
      -------------------------------------------------------------------------
        D i s p l a y   a   G r o u p   O v e r v i e w   P a g e
      =========================================================================
      */
?>
      <table cellpadding="0" cellspacing="0" width="100%"
             style="margin-top: 0; margin-bottom: 1.6em">
        <tr valign="bottom">
          <td width="2%" class="overviewTabCell" style="padding-left: 22px">
<?php
      // 'Previous Group' link.
      $prevGroupObj = &$groupObj->prevInAllGroups;
      if (is_object($prevGroupObj))
          echo $g_series->getGroupLinkStartTag($prevGroupObj);
      echo '<img src="../images/index-arrow-left.gif" border="0" '
           . 'width="16" height="16">';
      if (is_object($prevGroupObj))
          echo '</a>';
      echo '&nbsp;';
      if (is_object($prevGroupObj))
      {
          echo 'Group ' . $g_series->getGroupLinkStartTag($prevGroupObj) .'<b>'
             . $prevGroupObj->title . '</b></a>';
      }
      else
          echo '<font color="#999999">Series Begin</font>';
?>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
          </td>
          <!-- Page heading. -->
          <td width="10" class="overviewTabActiveLMCell">&nbsp;</td>
          <td width="1%" class="overviewTabActiveCell">
            &nbsp;
            <span class="overviewTabActiveText"><?php echo $pageTitle ?></span>
            &nbsp;</td>
          <td width="10" class="overviewTabActiveRMCell">&nbsp;</td>
          <td width="2%" class="overviewTabCell">
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<?php
      // 'Next Group' link.
      $nextGroupObj = &$groupObj->nextInAllGroups;
      if (is_object($nextGroupObj))
      {
          echo 'Group ' . $g_series->getGroupLinkStartTag($nextGroupObj) . '<b>'
             . $nextGroupObj->title . '</b></a>';
      }
      else
          echo '<font color="#999999">Series End</font>';
      echo '&nbsp;';
      if (is_object($nextGroupObj))
          echo $g_series->getGroupLinkStartTag($nextGroupObj);
      echo '<img src="../images/index-arrow-right.gif" border="0" '
          . 'width="16" height="16">';
      if (is_object($nextGroupObj))
          echo '</a>';
?>
          </td>
          <!-- Header end. -->
          <td width="*" class="overviewTabCell">&nbsp;</td>
        </tr>
      </table>
<div style="margin-left: 22px; margin-right: 22px">
<?php
      // Print the group title unless the group description contains an <h1>
      // or <h2> tag.
      $groupHeading = '';
      if (is_string($groupObj->description) && strlen($groupObj->description) > 0 &&
          !preg_match("!<h[0-9]>.*</h[0-9]>!", $groupObj->description) &&
          is_string($groupObj->title) && strlen($groupObj->title) > 0)
      {
          $groupHeading = $groupObj->title;
      }
      // Print the group description and determine whether to print the sub
      // groups and files.
      $bPrintSubGroups = true;
      $bPrintFiles = true;
      if (strlen($groupObj->description) > 0)
      {
          $descMiddle = $descEnd = '';
          $firstOp = $secondOp = 0;
          // Get the position of the tags and partition the string.
          $posSubGroups = strpos($groupObj->description, '<sub-group-list>');
          $subGroupsTagLength = 16;
          $posFiles = strpos($groupObj->description, '<file-list>');
          $filesTagLength = 11;
          if ($posSubGroups === false && $posFiles === false)
              $descBegin = $groupObj->description;
          else if ($posFiles === false)
          {
              $descBegin = trim(substr($groupObj->description, 0, $posSubGroups));
              $descMiddle = trim(substr(
                  $groupObj->description, $posSubGroups+$subGroupsTagLength));
              $firstOp = 1;
          }
          else if ($posSubGroups === false)
          {
              $descBegin = trim(substr($groupObj->description, 0, $posFiles));
              $descMiddle = trim(substr(
                  $groupObj->description, $posFiles + $filesTagLength));
              $firstOp = 2;
          }
          else
          {
              if ($posSubGroups < $posFiles)
              {
                  $pos1 = $posSubGroups;
                  $len1 = $subGroupsTagLength;
                  $pos2 = $posFiles;
                  $len2 = $filesTagLength;
                  $firstOp = 1;
                  $secondOp = 2;
              }
              else
              {
                  $pos2 = $posSubGroups;
                  $len2 = $subGroupsTagLength;
                  $pos1 = $posFiles;
                  $len1 = $filesTagLength;
                  $firstOp = 2;
                  $secondOp = 1;
              }
              $descBegin = trim(substr($groupObj->description, 0, $pos1));
              $descMiddle = trim(substr(
                  $groupObj->description, $pos1+$len1, $pos2-$pos1-$len1));
              $descEnd = trim(substr($groupObj->description, $pos2+$len2));
          }
          // Print the strings.
          $cssClass = '';
          $repl = "</p>\n<p>";
          if (is_object($groupObj->firstSubGroup))
          {
              $cssClass = 'clsLessTop';
              $repl = "</p>\n<p class=\"$cssClass\">";
              echo '<p class="' . $cssClass . '">';
          }
          else
              echo '<p>';
          // Write the group heading.
          if (strlen($groupHeading) > 0)
              echo "<h1>$groupHeading</h1>\n";
          // Write the group description.
          echo str_replace("\n\n", $repl, $descBegin) . "\n";
          if ($firstOp == 1)
          {
              $g_series->showSubGroups($groupObj, '');
              $bPrintSubGroups = 0;
          }
          else if ($firstOp == 2)
          {
              $g_series->showFiles($groupObj, 3);
              $bPrintFiles = 0;
          }
          if (strlen($descMiddle) > 0)
              echo str_replace("\n\n", $repl, $descMiddle) . "\n";
          if ($secondOp == 1)
          {
              $g_series->showSubGroups($groupObj, '');
              $bPrintSubGroups = 0;
          }
          else if ($secondOp == 2)
          {
              $g_series->showFiles($groupObj, 3);
              $bPrintFiles = 0;
          }
          if (strlen($descEnd) > 0)
              echo str_replace("\n\n", $repl, $descEnd) . "\n";
          echo "</p>\n";
      }
      // Display all sub groups and images of the current group.
      if ($bPrintSubGroups)
      {
          $g_series->showSubGroups($groupObj, (strlen($groupHeading) > 0) ?
              $groupHeading : 'Sub Groups');
      }
      if ($bPrintFiles)
          $g_series->showFiles($groupObj, 3);
?>
</div>
<table border="0" cellpadding="0" cellspacing="0"
       style="margin-top: 1.8em">
 <tr>
  <td width="2%" class="overviewTabBottomCell" style="padding-left: 22px">
<?php
      // 'Previous Group' link.
      $prevGroupObj = &$groupObj->prevInAllGroups;
      if (is_object($prevGroupObj))
          echo $g_series->getGroupLinkStartTag($prevGroupObj);
      echo '<img src="../images/index-arrow-left.gif" border="0" '
           . 'width="16" height="16">';
      if (is_object($prevGroupObj))
          echo '</a>';
      echo '&nbsp;';
      if (is_object($prevGroupObj))
      {
          echo 'Group ' . $g_series->getGroupLinkStartTag($prevGroupObj) .'<b>'
             . $prevGroupObj->title . '</b></a>';
      }
      else
          echo '<font color="#999999">Series Begin</font>';
?>
  </td>
  <td width="2%" class="overviewTabBottomCell">&nbsp;&nbsp;&nbsp;</td>
  <td width="2%" class="overviewTabBottomCell">
<?php
      // 'Next Group' link.
      $nextGroupObj = &$groupObj->nextInAllGroups;
      if (is_object($nextGroupObj))
      {
          echo 'Group ' . $g_series->getGroupLinkStartTag($nextGroupObj) . '<b>'
             . $nextGroupObj->title . '</b></a>';
      }
      else
          echo '<font color="#999999">Series End</font>';
      echo '&nbsp;';
      if (is_object($nextGroupObj))
          echo $g_series->getGroupLinkStartTag($nextGroupObj);
      echo '<img src="../images/index-arrow-right.gif" border="0" '
          . 'width="16" height="16">';
      if (is_object($nextGroupObj))
          echo '</a>';
?>
  </td>
  <td width="*" class="overviewTabBottomCell" style="padding-right: 22px"
      align="right">
    <span class="imageCopyright">
      <a href="copyright.html">&copy;
      <?php
        $year = '';
        if (is_object($groupObj))
            $year = $groupObj->getYear(GET_BEGIN_DATE);
        else
            $year = $g_series->getYear(GET_BEGIN_DATE);
        if (strlen($year) == 0)
            $year = date('Y');
        echo $year;
      ?>
      Dirk S. Grossmann</a>
    </span>
  </td>
 </tr>
</table>
<p>&nbsp;</p>
<?php
  }
?>
</div>
</body>
</html>
