/*
-------------------------------------------------------------------------------
  P h o t o   E x a m p l e   A p p l i c a t i o n

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
       File: "ExportSeriesToDBAspect.java"
    Created: 24.03.2006 (18:59:27)
        $Id: ExportSeriesToDBAspect.aj 78 2006-04-02 07:31:57Z Dirk $
  $Revision: 78 $
      $Date: 2006-04-02 09:31:57 +0200 (So, 02 Apr 2006) $
    $Author: Dirk $
===============================================================================
*/
package com.dgrossmann.photo.dir.persist_db;

import java.awt.Color;
import java.awt.event.ActionEvent;

import javax.swing.JMenuItem;
import javax.swing.JSeparator;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.ui.panel.DirTreePanel;

/**
 * Aspect that enhances JPhoto-Explorer with the functionality to export a
 * series to the database. This database is used by the Photo Example
 * application.
 * @author Dirk Grossmann
 */
public privileged aspect ExportSeriesToDBAspect
{
    /**
     * Member variable for the "Export to DB" menu item.
     */
    private JMenuItem DirTreePanel.m_dpExportSeriesToDB = null;

    /**
     * After advice to add the "Export to DB" menu item to the context menu.
     */
    after (DirTreePanel panel) :
        execution(void DirTreePanel.createDirContextMenu()) &&
        this(panel)
    {
        if (panel.m_dpExportSeriesToDB != null)
            return;
        JSeparator sep = new JSeparator();
        sep.setBackground(new Color(255, 255, 255));
        sep.setForeground(new Color(153, 153, 153));
        panel.m_dirPopupMenu.add(sep);
        panel.m_dpExportSeriesToDB = new JMenuItem("Export Series to Database");
        panel.m_dpExportSeriesToDB.addActionListener(panel);
        panel.m_dirPopupMenu.add(panel.m_dpExportSeriesToDB);
    } // after createDirContextMenu

    /**
     * After advice to execute the "Export to DB" action.
     */
    after (DirTreePanel panel, ActionEvent e) :
        execution(void DirTreePanel.actionPerformed(ActionEvent)) &&
        this(panel) && args(e)
    {
        if (e.getSource() == panel.m_dpExportSeriesToDB)
        {
            DirectoryObject dirObj = panel.getCurrentDirectory();
            if (dirObj == null || dirObj.getParent() != null)
                return;
            try
            {
                SeriesPersister sp = new SeriesPersister(panel.getFrame());
                sp.saveToDatabase(dirObj, true, true, true);
            }
            catch (Throwable exc)
            {
                if (exc.getCause() != null)
                    exc = exc.getCause();
                System.out.println("Exception: " + exc);
                exc.printStackTrace();
            }
        }
    } // after actionPerformed
} // ExportSeriesToDBAspect
