/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: AppInfo
    Created: 2 January, 2003
        $Id: AppInfo.tmpl 161 2009-08-02 07:36:03Z dirk $
  $Revision: 161 $
      $Date: 2009-08-02 09:36:03 +0200 (So, 02 Aug 2009) $
    $Author: dirk $
===============================================================================
*/

package com.dgrossmann.photo;

/**
 * JPhoto-Explorer application version information class.
 */
public class AppInfo
{
    public static final String APP_NAME  = "J Photo-Explorer";

    public static final int BUILD_YEAR   = 2014;
    public static final int BUILD_MONTH  = 1;
    public static final int BUILD_DAY    = 15;
    public static final int BUILD_HOUR   = 22;
    public static final int BUILD_MINUTE = 40;

    public static final int BUILD_VERSION_MAJOR = 3;
    public static final int BUILD_VERSION_MINOR = 2;
    public static final String BUILD_VERSION_PATCHLEVEL =
        "1";
    public static final String BUILD_VERSION_SUPPLEMENT =
        "";

    /**
     * Gets the program version as string.
     * @return The version string
     */
    public static String getVersionString ()
    {
        String str;

        str = "" + BUILD_VERSION_MAJOR + "." + BUILD_VERSION_MINOR;
        if (BUILD_VERSION_PATCHLEVEL.length() > 0)
        {
            try
            {
                int i = Integer.parseInt(BUILD_VERSION_PATCHLEVEL);
                str += "." + i;
            }
            catch (Throwable thr)
            {
                str += BUILD_VERSION_PATCHLEVEL;
            }
        }
        if (BUILD_VERSION_SUPPLEMENT.length() > 0)
            str += " " + BUILD_VERSION_SUPPLEMENT;
        return str;
    } // getVersionString

    private static final String[] monthNames =
    {
        "January", "February", "March", "April", "May", "June", "July",
        "August", "September", "October", "November", "December"
    };

    /**
     * Gets the program build date as string.
     * @param bShort - Short format
     * @return The build date
     */
    @SuppressWarnings("all")
    public static String getBuildDate (boolean bShort)
    {
        String str;

        if (bShort)
        {
            str = "" + ((BUILD_DAY <= 9) ? "0" : "") + BUILD_DAY + "/"
                + ((BUILD_MONTH <= 9) ? "0" : "") + BUILD_MONTH + "/"
                + BUILD_YEAR;
        }
        else
        {
            str = "" + BUILD_DAY + " " + monthNames[BUILD_MONTH-1]
                + ", " + BUILD_YEAR;
        }
        str += " (" + ((BUILD_HOUR <= 9) ? "0" : "") + BUILD_HOUR + ":"
            + ((BUILD_MINUTE <= 9) ? "0" : "") + BUILD_MINUTE + ")";
        return str;
    } // getBuildDate
} // AppInfo
