/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: Main
    Created: Jan 10, 2004  (4:27:55 PM)
        $Id: Main.java 158 2009-05-06 19:49:13Z dirk $
  $Revision: 158 $
      $Date: 2009-05-06 21:49:13 +0200 (Mi, 06 Mai 2009) $
    $Author: dirk $
===============================================================================
*/

package com.dgrossmann.photo;

import java.util.StringTokenizer;

import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import com.sun.java.swing.plaf.motif.MotifLookAndFeel;

import com.dgrossmann.photo.ui.ExplorerMainFrame;

/**
 * <i>J Photo-Explorer</b> application main class.
 * @author Dirk Grossmann
 */
public class Main
{
    private static final int LOAD_DEFAULT_UI = 0;
    private static final int LOAD_SYSTEM_UI  = 1;
    private static final int LOAD_MOTIF_UI   = 2;
    private static final int LOAD_METAL_UI   = 3;
    private static final int LOAD_DIRECT_UI  = 5;

    /**
     * Application start method.
     * @param args - The command line arguments
     */
    public static void main (String[] args)
    {
        String          loadUIClass = null;
        int             loadUI      = LOAD_DEFAULT_UI;
        boolean         bUILoaded   = false;
        boolean         bLoadCond;
        String          javaVersion;
        StringTokenizer tok;
        int             i, index;

        // "Parse" the command line arguments.
        for (i = 0; i < args.length; i++)
        {
            if (args[i].equalsIgnoreCase("-ui") && i < args.length - 1)
            {
                loadUIClass = args[++i];
                if (loadUIClass.equalsIgnoreCase("system") ||
                    loadUIClass.equalsIgnoreCase("windows"))
                {
                    loadUI = LOAD_SYSTEM_UI;
                    loadUIClass = null;
                }
                else if (loadUIClass.equalsIgnoreCase("motif"))
                {
                    loadUI = LOAD_MOTIF_UI;
                    loadUIClass = null;
                }
                else if (loadUIClass.equalsIgnoreCase("metal"))
                {
                    loadUI = LOAD_METAL_UI;
                    loadUIClass = null;
                }
                else
                    loadUI = LOAD_DIRECT_UI;
            }
        }
        // Try to load the system-specific look and feel.
        String osName = System.getProperty("os.name");
        if (loadUI == LOAD_SYSTEM_UI || (loadUI == LOAD_DEFAULT_UI &&
            osName != null && osName.equalsIgnoreCase("Windows XP")))
        {
            if (loadUI == LOAD_SYSTEM_UI)
                bLoadCond = true;
            else
            {
                bLoadCond = false;
                javaVersion = System.getProperty("java.version");
                index = javaVersion.indexOf("_");
                if (index > 0)
                    javaVersion = javaVersion.substring(0, index);
                tok = new StringTokenizer(javaVersion, ".");
                if (tok.countTokens() >= 3)
                {
                    try
                    {
                        float vers = Float.parseFloat
                            (tok.nextToken() + "." + tok.nextToken()
                                + tok.nextToken());
                        if (vers >= 1.42F)
                            bLoadCond = true;
                    }
                    catch (Exception ignored)
                    {
                    }
                }
            }
            try
            {
                if (bLoadCond)
                {
                    // Set the system look and feel for Windows XP.
                    UIManager.setLookAndFeel
                        (UIManager.getSystemLookAndFeelClassName());
                    bUILoaded = true;
                }
            }
            catch (Exception ignored)
            {
            }
        }
        // Try to load the Motif look and feel.
        if (!bUILoaded && loadUI == LOAD_MOTIF_UI)
        {
            try
            {
                UIManager.setLookAndFeel(new MotifLookAndFeel());
                bUILoaded = true;
            }
            catch (UnsupportedLookAndFeelException ignored)
            {
            }
        }
        // Try to load the specified look and feel class.
        if (!bUILoaded && loadUI == LOAD_DIRECT_UI && loadUIClass != null)
        {
            try
            {
                Object plf = Class.forName(loadUIClass).newInstance();
                if (plf instanceof LookAndFeel)
                {
                    UIManager.setLookAndFeel((LookAndFeel) plf);
                    bUILoaded = true;
                }
            }
            catch (Exception e)
            {
            }
        }
        // Create the main window (this will implicitly show it).
        new ExplorerMainFrame();
    } // main
} // Main
