/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: ExportTimerTask
    Created: 13 January, 2003
        $Id: ExportTimerTask.java 41 2006-01-14 15:49:02Z Dirk $
  $Revision: 41 $
      $Date: 2006-01-14 16:49:02 +0100 (Sa, 14 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import com.dgrossmann.photo.AppInfo;
import com.dgrossmann.photo.ui.dialog.ExportProgressDialog;

/**
 * Helper class for the export timer used in the main frame class to monitor
 * the export progress.
 */
public class ExportTimerTask implements ActionListener
{
    private ExplorerMainFrame    m_frame;
    private ExportProgressDialog m_dlg;

    /**
     * Creates a new <tt>ExportTimerTask</tt> instance.
     * @param frm - The Explorer frame
     * @param dlg - The progress dialog to report the progress to
     */
    public ExportTimerTask
        ( ExplorerMainFrame    frm
        , ExportProgressDialog dlg
        )
    {
        m_frame = frm;
        m_dlg = dlg;
    } // ExportTimerTask
    
    public void actionPerformed (ActionEvent evt)
    {
        synchronized(m_frame.m_exportReady)
        {
            m_dlg.setProgress(m_frame.getExportProgress());
            if (m_frame.m_exportReady.booleanValue())
            {
                m_dlg.close();
                m_frame.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
                if (m_frame.m_exportTimer != null)
                    m_frame.m_exportTimer.stop();
                m_frame.m_exportTimer = null;
                m_frame.m_exportStop = false;
                if (m_frame.m_exportError != null)
                {
                    JOptionPane.showMessageDialog(m_frame, "Export Error: "
                        + m_frame.m_exportError, AppInfo.APP_NAME,
                        JOptionPane.ERROR_MESSAGE);
                    m_frame.m_exportError = null;
                }
                m_frame.onExportReady();
            }
        }
    } // actionPerformed
} // ExportTimerTask
