/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: ShellExec
    Created: 2 January, 2003
        $Id: ShellExec.java 41 2006-01-14 15:49:02Z Dirk $
  $Revision: 41 $
      $Date: 2006-01-14 16:49:02 +0100 (Sa, 14 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui;

import java.awt.Dialog;
import java.awt.Frame;

import javax.swing.JOptionPane;

import com.dgrossmann.photo.AppInfo;
import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.ui.dialog.HtmlViewDialog;
import com.dgrossmann.photo.ui.dialog.ImageViewDialog;
import com.dgrossmann.photo.ui.dialog.TextViewDialog;

/**
 * Wraps the "ShellExecute" Win32 function.
 */
public class ShellExec
{
    private Frame  m_parentFrame;
    private Dialog m_parentDialog;

    /**
     * Creates a new <tt>ShellExec</tt> instance.
     * @param parentFrame - Parent frame
     */
    public ShellExec (Frame parentFrame)
    {
        m_parentFrame = parentFrame;
        m_parentDialog = null;
    } // ShellExec

    /**
     * Creates a new <tt>ShellExec</tt> instance.
     * @param parentDialog - Parent dialog
     */
    public ShellExec (Dialog parentDialog)
    {
        m_parentFrame = null;
        m_parentDialog = parentDialog;
    } // ShellExec

    /**
     * Opens a file using the application registered for the file type.
     * @param fileObj - File object to open
     */
    public void openDocument (FileObject fileObj)
    {
        ImageViewDialog imgDlg;
        HtmlViewDialog  htmlDlg;
        TextViewDialog  textDlg;
        String          title, path;

        title = fileObj.getTitlePlain();
        path = (fileObj.isReference()) ? fileObj.get(AbstractFSObject.HREF)
            : fileObj.getFullPath();
        switch (fileObj.getFileType())
        {
            case FileObject.TYPE_IMAGE_PREVIEW:
                imgDlg =  (m_parentFrame != null) ?
                    new ImageViewDialog(fileObj, m_parentFrame, false) :
                    new ImageViewDialog(fileObj, m_parentDialog, false);
                imgDlg.setVisible(true);
                break;
            case FileObject.TYPE_HTML_DOC:
            case FileObject.TYPE_HTML_REF:
                htmlDlg = (m_parentFrame != null) ?
                    new HtmlViewDialog(m_parentFrame, title, path, false) :
                    new HtmlViewDialog(m_parentDialog, title, path, false);
                htmlDlg.setVisible(true);
                break;
            case FileObject.TYPE_TEXT_DOC:
            case FileObject.TYPE_XML_DOC:
                textDlg = (m_parentFrame != null) ?
                    new TextViewDialog(m_parentFrame, title, path, false) :
                    new TextViewDialog(m_parentDialog, title, path, false);
                textDlg.setVisible(true);
                break;
            default:
                // Open the file.
                try
                {
                    Runtime.getRuntime().exec(new String[] {
                        "cmd", "/c", "start", fileObj.getFullPath()
                    });
                }
                catch (Exception e)
                {
                    JOptionPane.showMessageDialog(null,
                        "Cannot open file \"" + fileObj.getFullPath()
                        + "\"\nException: " + e,
                        AppInfo.APP_NAME, JOptionPane.ERROR_MESSAGE);
                }
        }
    } // openDocument
} // ShellExec
