/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: EnterDirNameDialog
    Created: 28 February, 2003
        $Id: EnterDirNameDialog.java 160 2009-05-31 07:57:29Z dirk $
  $Revision: 160 $
      $Date: 2009-05-31 09:57:29 +0200 (So, 31 Mai 2009) $
    $Author: dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.dialog;

import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Iterator;

import javax.swing.JDialog;
import javax.swing.JOptionPane;

import com.dgrossmann.photo.AppInfo;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;

/**
 * Dialog class for entering a new folder name.
 */
public class EnterDirNameDialog extends JDialog
{
    private DirectoryObject m_parentDir;
    private boolean         m_bIsChanged;

    /**
     * Creates a new <tt>EnterDirNameDialog</tt> form instance.
     * @param parent - Parent frame in the user interface
     * @param parentDir - Parent directory object for the new subdirectory
     * @param modal - <tt>True</tt> for a modal dialog
     */
    public EnterDirNameDialog
        ( Frame           parent
        , DirectoryObject parentDir
        , boolean         modal
        )
    {
        super(parent, modal);
        m_parentDir = parentDir;
        m_bIsChanged = false;
        this.initComponents();
        descLabel.setText("This dialog creates a new folder under \""
            + parentDir.getFileName() + "\".");
        // Position centered in the parent dialog.
        Rectangle parentRect = parent.getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0)
            thisRect.x = 0;
        if (thisRect.y < 0)
            thisRect.y = 0;
        this.setBounds(thisRect);
        this.setResizable(false);
    } // EnterDirNameDialog

    /**
     * Shows the dialog window.
     * @return <tt>True</tt> if the user made changes, <tt>false</tt> if she
     * canceled the dialog
     */
    public boolean showDialog ()
    {
        this.setVisible(true);
        return m_bIsChanged;
    } // showDialog;

    public String getDirName ()
    {
        return dirNameTextField.getText();
    } // getDirName

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        java.awt.GridBagConstraints gridBagConstraints;

        contentPanel = new javax.swing.JPanel();
        iconLabel = new javax.swing.JLabel();
        descLabel = new javax.swing.JLabel();
        descLabel2 = new javax.swing.JLabel();
        dirNameTextField = new javax.swing.JTextField();
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        this.getContentPane().setLayout(new java.awt.GridBagLayout());

        this.setTitle("New Subfolder");
        this.addWindowListener(new java.awt.event.WindowAdapter()
        {
            @Override
			public void windowClosing(java.awt.event.WindowEvent evt)
            {
                EnterDirNameDialog.this.closeDialog(evt);
            }
        });

        contentPanel.setLayout(new java.awt.GridBagLayout());

        iconLabel.setIcon(new javax.swing.ImageIcon(this.getClass().getResource("/images/type-dir.gif")));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        contentPanel.add(iconLabel, gridBagConstraints);

        descLabel.setText("This dialog creates a new folder under");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        contentPanel.add(descLabel, gridBagConstraints);

        descLabel2.setText("Please enter the name of the new folder:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 12, 0, 150);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        contentPanel.add(descLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 6, 4);
        contentPanel.add(dirNameTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        this.getContentPane().add(contentPanel, gridBagConstraints);

        buttonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                EnterDirNameDialog.this.okButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(okButton);

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                EnterDirNameDialog.this.cancelButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 6);
        this.getContentPane().add(buttonPanel, gridBagConstraints);

        this.pack();
    }//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
    {//GEN-HEADEREND:event_cancelButtonActionPerformed
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_okButtonActionPerformed
    {//GEN-HEADEREND:event_okButtonActionPerformed
        Iterator<DirectoryObject> subDirIter;
        Iterator<FileObject>      fileIter;
        String                    name;
        boolean                   bFound;

        name = dirNameTextField.getText();
        if (name == null || name.length() == 0)
        {
            JOptionPane.showMessageDialog
                (this, "Please enter a folder name.", AppInfo.APP_NAME,
                JOptionPane.WARNING_MESSAGE);
            return;
        }
        // Check that the "name" is not used in the parent directory.
        bFound = false;
        subDirIter = m_parentDir.getSubDirIterator();
        while (subDirIter.hasNext())
        {
            if (subDirIter.next().getFileName().equalsIgnoreCase(name))
            {
                bFound = true;
                break;
            }
        }
        if (!bFound)
        {
        	fileIter = m_parentDir.getFileIterator();
            while (fileIter.hasNext())
            {
                if (fileIter.next().getFileName().equalsIgnoreCase(name))
                {
                    bFound = true;
                    break;
                }
            }
        }
        if (bFound)
        {
            JOptionPane.showMessageDialog
                (this, "\"" + name + "\" is already used in the parent "
                + "directory \"" + m_parentDir.getFileName()
                + "\".\n\nPlease enter a different directory name.",
                AppInfo.APP_NAME,
                JOptionPane.WARNING_MESSAGE);
            return;
        }
        // Now we can close the dialog.
        m_bIsChanged = true;
        this.cancelButtonActionPerformed(evt);
    }//GEN-LAST:event_okButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt)
    {//GEN-FIRST:event_closeDialog
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel iconLabel;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel descLabel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JTextField dirNameTextField;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JLabel descLabel2;
    private javax.swing.JPanel contentPanel;
    // End of variables declaration//GEN-END:variables

} // EnterDirNameDialog
