/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: ExportProgressDialog
    Created: 13 January, 2003
        $Id: ExportProgressDialog.java 42 2006-01-21 17:47:48Z Dirk $
  $Revision: 42 $
      $Date: 2006-01-21 18:47:48 +0100 (Sa, 21 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.dialog;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;

import javax.swing.JDialog;
import javax.swing.WindowConstants;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.webexport.ExportProgress;

/**
 * Web export progress dialog class.
 */
public class ExportProgressDialog extends JDialog
{
    private ExplorerMainFrame m_parent;
    private ExportProgress    m_progress;
    private int               m_currentFileNumber, m_fileCount;
    private int               m_pCurrent, m_pMax;

    /**
     * Creates a new <tt>ExportProgressDialog</tt> form instance.
     * @param parent - Parent main frame in the UI
     * @param exporterDescription - Description of the exporter used
     * @param fileCount - Overall file count to be exported
     */
    public ExportProgressDialog
        ( ExplorerMainFrame parent
        , String            exporterDescription
        , int               fileCount
        )
    {
        super(parent, false);
        this.initComponents();
        this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        // Set the instance data.
        m_parent = parent;
        m_fileCount = fileCount;
        m_currentFileNumber = 0;
        m_progress = null;
        fileCountLabel.setText("  " + m_fileCount + " files to export");
        m_pCurrent = 0;
        m_pMax = 3 * m_fileCount;
        if (exporterDescription.length() > 0)
            usingLabel.setText("  Using " + exporterDescription);
        // Position the dialog centered in the parent dialog.
        Rectangle parentRect, thisRect;
        parentRect = parent.getBounds();
        thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0)
            thisRect.x = 0;
        if (thisRect.y < 0)
            thisRect.y = 0;
        this.setBounds(thisRect);
    } // ExportProgressDialog

    private void setProgressValue ()
    {
        if (m_pMax > 0)
            progressBar.setValue((m_pCurrent * 100) / m_pMax);
    } // setProgressValue

	/** Sets the progress status. */
    public void setProgress (ExportProgress p)
    {
        DirectoryObject parentDir;
        Dimension       dim;
        String          outDir, mainName, indexName, series, group;

        if (p == null)
            return;
        // Is it a new file ?-
        m_progress = p;
        if (m_currentFileNumber != m_progress.getCurrentFileNumber())
        {
            m_currentFileNumber = m_progress.getCurrentFileNumber();
            m_pCurrent = 3 * (m_currentFileNumber-1);
            this.setProgressValue();
            fileCountLabel.setText("  Exporting file " + m_currentFileNumber
                + " of " + m_fileCount);
        }
        // Set the source file information.
        parentDir = (DirectoryObject) m_progress.getFileObject().getParent();
        if (parentDir != null)
        {
            group = parentDir.getTitlePlain();
            if (parentDir.getParent() != null)
            {
                while (parentDir.getParent() != null)
                	parentDir = (DirectoryObject) parentDir.getParent();
                series = parentDir.getTitlePlain();
            }
            else
            {
                series = group;
                group = " ";
            }
            seriesValLabel.setText(series);
            groupLabel.setText((group.length() > 0) ? " Group:" : " ");
            groupValLabel.setText(group);
        }
        sourceFileLabel.setText(m_progress.getFileObject().getFullPath());
        dim = m_progress.getOriginalSize();
        if (dim != null)
        {
            m_pCurrent = 3 * (m_currentFileNumber-1) + 1;
            this.setProgressValue();
            sourceFileSizeLabel.setText("" + dim.width + " x " + dim.height
                + " pixels");
        }
        else
            sourceFileSizeLabel.setText(" ");
        // Update the destination file properties.
        mainFileLabel.setText(" ");
        mainFileSizeLabel.setText(" ");
        indexFileLabel.setText(" ");
        indexFileSizeLabel.setText(" ");
        outDir = m_progress.getOutputDirectory();
        mainName = m_progress.getMainFileName();
        indexName = m_progress.getIndexFileName();
        if (outDir.length() > 0)
        {
            if (mainName.length() > 0)
            {
                if (m_progress.isMainReady())
                {
                    m_pCurrent = 3 * (m_currentFileNumber-1) + 2;
                    this.setProgressValue();
                }
                mainFileLabel.setText(outDir + File.separator + mainName);
                if (m_progress.isMainUpToDate())
                    mainFileSizeLabel.setText("Up-to-date");
                else
                {
	                dim = m_progress.getMainSize();
	                if (dim != null)
	                {
	                    mainFileSizeLabel.setText("" + dim.width + " x "
	                        + dim.height + " pixels" +
                            (m_progress.isMainReady() ? " - Ready" : ""));
	                }
                }
            }
            if (indexName.length() > 0)
            {
                indexFileLabel.setText(outDir + File.separator + indexName);
                if (m_progress.isIndexUpToDate())
                    indexFileSizeLabel.setText("Up-to-date");
                else
                {
	                dim = m_progress.getIndexSize();
	                if (dim != null)
	                {
	                    indexFileSizeLabel.setText("" + dim.width + " x "
	                        + dim.height + " pixels" +
                            (m_progress.isIndexReady() ? " - Ready" : ""));
	                }
                }
            }
        }
    } // setProgress

    /** Closes the dialog. */
    public void close ()
    {
        this.setVisible(false);
        this.dispose();
    } // close

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        java.awt.GridBagConstraints gridBagConstraints;

        titleLabel = new javax.swing.JLabel();
        usingLabel = new javax.swing.JLabel();
        currentGroupPanel = new javax.swing.JPanel();
        seriesLabel = new javax.swing.JLabel();
        seriesValLabel = new javax.swing.JLabel();
        groupLabel = new javax.swing.JLabel();
        groupValLabel = new javax.swing.JLabel();
        currentFilePanel = new javax.swing.JPanel();
        srcLabel = new javax.swing.JLabel();
        sourceFileLabel = new javax.swing.JLabel();
        sourceFileSizeLabel = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        mainLabel = new javax.swing.JLabel();
        mainFileLabel = new javax.swing.JLabel();
        mainFileSizeLabel = new javax.swing.JLabel();
        indexLabel = new javax.swing.JLabel();
        indexFileLabel = new javax.swing.JLabel();
        indexFileSizeLabel = new javax.swing.JLabel();
        progressPanel = new javax.swing.JPanel();
        progressBar = new javax.swing.JProgressBar();
        bottomPanel = new javax.swing.JPanel();
        fileCountLabel = new javax.swing.JLabel();
        buttonPanel = new javax.swing.JPanel();
        cancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Web Export Progress");
        setResizable(false);
        titleLabel.setText("  The images are being exported to the Web export directory.  Please be patient for a moment.       ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        getContentPane().add(titleLabel, gridBagConstraints);

        usingLabel.setText("  Using");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 6);
        getContentPane().add(usingLabel, gridBagConstraints);

        currentGroupPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 6, 5));

        currentGroupPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Current Group"));
        seriesLabel.setText("Series:");
        currentGroupPanel.add(seriesLabel);

        seriesValLabel.setForeground(new java.awt.Color(0, 70, 213));
        seriesValLabel.setText(" ");
        currentGroupPanel.add(seriesValLabel);

        groupLabel.setText(" ");
        currentGroupPanel.add(groupLabel);

        groupValLabel.setForeground(new java.awt.Color(0, 70, 213));
        groupValLabel.setText(" ");
        currentGroupPanel.add(groupValLabel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 6);
        getContentPane().add(currentGroupPanel, gridBagConstraints);

        currentFilePanel.setLayout(new java.awt.GridBagLayout());

        currentFilePanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Current File"));
        srcLabel.setText("Source:  ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        currentFilePanel.add(srcLabel, gridBagConstraints);

        sourceFileLabel.setForeground(new java.awt.Color(0, 70, 213));
        sourceFileLabel.setText("  ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        currentFilePanel.add(sourceFileLabel, gridBagConstraints);

        sourceFileSizeLabel.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        currentFilePanel.add(sourceFileSizeLabel, gridBagConstraints);

        jSeparator1.setForeground(new java.awt.Color(208, 208, 191));
        jSeparator1.setMinimumSize(new java.awt.Dimension(3, 3));
        jSeparator1.setPreferredSize(new java.awt.Dimension(6, 3));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 6, 0, 6);
        currentFilePanel.add(jSeparator1, gridBagConstraints);

        mainLabel.setText("Main Image:  ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 6, 0, 0);
        currentFilePanel.add(mainLabel, gridBagConstraints);

        mainFileLabel.setForeground(new java.awt.Color(0, 70, 213));
        mainFileLabel.setText("  ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        currentFilePanel.add(mainFileLabel, gridBagConstraints);

        mainFileSizeLabel.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        currentFilePanel.add(mainFileSizeLabel, gridBagConstraints);

        indexLabel.setText("Index Image:  ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        currentFilePanel.add(indexLabel, gridBagConstraints);

        indexFileLabel.setForeground(new java.awt.Color(0, 70, 213));
        indexFileLabel.setText("  ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        currentFilePanel.add(indexFileLabel, gridBagConstraints);

        indexFileSizeLabel.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        currentFilePanel.add(indexFileSizeLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 6);
        getContentPane().add(currentFilePanel, gridBagConstraints);

        progressPanel.setLayout(new java.awt.GridBagLayout());

        progressPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Overall Progress"));
        progressBar.setForeground(new java.awt.Color(0, 70, 213));
        progressBar.setStringPainted(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 4, 6);
        progressPanel.add(progressBar, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 6);
        getContentPane().add(progressPanel, gridBagConstraints);

        bottomPanel.setLayout(new java.awt.GridBagLayout());

        fileCountLabel.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        bottomPanel.add(fileCountLabel, gridBagConstraints);

        buttonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                cancelButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        bottomPanel.add(buttonPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 6);
        getContentPane().add(bottomPanel, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
    {//GEN-HEADEREND:event_cancelButtonActionPerformed
        m_parent.stopExport();
        fileCountLabel.setText("  Export is being canceled ...");
        cancelButton.setEnabled(false);
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel currentFilePanel;
    private javax.swing.JPanel currentGroupPanel;
    private javax.swing.JLabel fileCountLabel;
    private javax.swing.JLabel groupLabel;
    private javax.swing.JLabel groupValLabel;
    private javax.swing.JLabel indexFileLabel;
    private javax.swing.JLabel indexFileSizeLabel;
    private javax.swing.JLabel indexLabel;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel mainFileLabel;
    private javax.swing.JLabel mainFileSizeLabel;
    private javax.swing.JLabel mainLabel;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JPanel progressPanel;
    private javax.swing.JLabel seriesLabel;
    private javax.swing.JLabel seriesValLabel;
    private javax.swing.JLabel sourceFileLabel;
    private javax.swing.JLabel sourceFileSizeLabel;
    private javax.swing.JLabel srcLabel;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JLabel usingLabel;
    // End of variables declaration//GEN-END:variables
    
} // ExportProgressDialog
