/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: DirTreeMouseListener
    Created: 2 January, 2003
        $Id: DirTreeMouseListener.java 76 2006-03-29 19:16:10Z Dirk $
  $Revision: 76 $
      $Date: 2006-03-29 21:16:10 +0200 (Mi, 29 Mrz 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.panel;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import com.dgrossmann.photo.ui.ExplorerMainFrame;

/**
 * Mouse listener for the double-click (showing the file properties dialog) and
 * the context menu in the contents list table.
 */
public class DirTreeMouseListener extends MouseAdapter
{
    private DirTreePanel m_parentPanel;

    /**
     * Creates a new <tt>CFileTableMouseListener</tt> instance.
     * @param parentPanel - Parent panel
      */
    public DirTreeMouseListener(DirTreePanel parentPanel)
    {
        super();
        m_parentPanel = parentPanel;
    } // DirTreeMouseListener

    /**
     * Mouse pressed handler that might show the directory context menu.
     * @param e - Mouse event
     */
    public void mousePressed (MouseEvent e)
    {
        if (e.isPopupTrigger())
            m_parentPanel.showDirContextMenu(e.getX(), e.getY());
    } // mousePressed

    /**
     * Mouse pressed handler that shows the directory context menu.
     * @param e - Mouse event
     */
    public void mouseReleased (MouseEvent e)
    {
        if (e.isPopupTrigger())
            m_parentPanel.showDirContextMenu(e.getX(), e.getY());
    } // mouseReleased
} // DirTreeMouseListener
