/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: IExplorerPanelChangeListener
    Created: 17 December, 2005
        $Id: IExplorerPanelChangeListener.java 159 2009-05-19 19:40:47Z dirk $
  $Revision: 159 $
      $Date: 2009-05-19 21:40:47 +0200 (Di, 19 Mai 2009) $
    $Author: dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.panel;

import java.util.List;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;

/**
 * Listener interface Explorer panels use to inform another components about
 * changes.
 * @author Dirk Grossmann
 */
public interface IExplorerPanelChangeListener
{
    /**
     * Informs that the current directory has changed.
     * @param source - The source panel
     * @param dirObj - The new current directory
     */
    public void onCurrentDirectoryChanged
        ( IExplorerPanel  source
        , DirectoryObject dirObj
        );

    /**
     * Informs that the selection has changed.
     * @param source - The source panel
     * @param newSelectedObjects - List of the currently selected
     * {@link com.dgrossmann.photo.dir.AbstractFSObject}s
     */
    public void onSelectionChanged
        ( IExplorerPanel         source
        , List<AbstractFSObject> newSelectedObjects
        );

    /**
     * Informs that the child structure of a directory object has changed.
     * @param source - The source panel
     * @param dirObj - The changed directory object
     */
    public void onStructureChanged
        ( IExplorerPanel  source
        , DirectoryObject dirObj
        );

    /**
     * Informs that the properties of a file system object have changed.
     * @param source - The source panel
     * @param fsObj - The changed file system object
     */
    public void onPropertiesChanged
        ( IExplorerPanel   source
        , AbstractFSObject fsObj
        );
} // IExplorerPanelChangeListener
