/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: PanelTitleChangeListener
    Created: 14.02.2006 (18:32:33)
        $Id: $
  $Revision: $
      $Date: $
    $Author: $
===============================================================================
*/

package com.dgrossmann.photo.ui.panel;

/**
 * Interface that signals changes in a title component.
 * @author Dirk Grossmann
 */
public interface PanelTitleChangeListener
{
    public static final int SEL_NORMAL  = 0;
    public static final int SEL_PREVIEW = 1;

    /**
     * Called when the selection changes.
     * @param panelId - The identifier of the selected panel; currently
     * {@link #SEL_NORMAL} for the normal panel and {@link #SEL_PREVIEW} for the
     * preview panel
     */
    public void onTitleSelectionChanged (int panelId);
} // PanelTitleChangeListener
