/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: ExportFactory
    Created: 9 January, 2003
        $Id: ExportFactory.java 34 2006-01-06 11:28:57Z Dirk $
  $Revision: 34 $
      $Date: 2006-01-06 12:28:57 +0100 (Fr, 06 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.webexport;

import java.awt.Component;

import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.settings.Settings;

/**
 * Factory for web exporter objects.
 */
public class ExportFactory
{
    private static IWebExport s_magickExporter = null; 
    private static IWebExport s_javaExporter   = null; 

    /**
     * Gets the web exporter object.
     * @param settings - Settings object
     * @param sContainer - Series container object
     * @param parent - Parent component (for image loading)
     * @return IWebExport
     */
    public static IWebExport getExport
        ( Settings        settings
        , SeriesContainer sContainer
        , Component       parent
        )
    {
        int useMagick = settings.getInt(Settings.EXPORT_USE_IMAGE_MAGICK, 0);
        if (useMagick > 0)
        {
            if (s_magickExporter == null)
            {
                s_magickExporter = new ImageMagickExporter();
                s_magickExporter.setEnvironment(settings, sContainer, parent);
            }
            if (s_magickExporter.isAvailable())
            {
                return s_magickExporter;
            }
        }
        if (s_javaExporter == null)
        {
            s_javaExporter = new JavaExporter();
            s_javaExporter.setEnvironment(settings, sContainer, parent);
        }
        return s_javaExporter;
    }
} // ExportFactory
