/* elcom.c -- Hauptprogramm */

#include <signal.h>
#include "elcom.h"

extern int analyse(FILE *);                /* el_syn.y   */
extern int stop_print(char *);             /* el_print.c */
extern int scope(void);                    /* el_scope.c */
extern struct ausdruck *apptrans
(struct ausdruck *, int);                  /* el_app.c   */
extern struct ausdruck *elim
(struct ausdruck *);                       /* el_app.c   */
extern neuniv (struct ausdruck *, int);    /* el_app.c   */
extern lift (struct ausdruck *);           /* el_lift.c  */
extern codegen (char *);                   /* el_code.c  */

char *aus1 = "\nELCOM  Version 1.0 -- 17th June 1991";
char *aus2 = "Usage: elcom [-q] [-s] [-v] file[.el] \n";
char *aus3 = "Compiles extended lambda calculus to G-code";
char *aus4 = "Eliminating redundant %s. \n";

FILE *f;
char fname[85], fbasis[85];

int  msg  = 1;
int  stop = 0;

struct typliste *defs = NULL;      /* Die Typliste       */
struct ausdruck *prog = NULL;      /* Der Ausdruck       */
struct comliste *comb = NULL;      /* Kombinatoren-Liste */
struct comliste *last = NULL;      /* Letzter Kombinator */

struct hashtab  *hash[HASHSIZE];   /* Hash-Tabelle       */

interrupt (s)
int  s;
{
    char *c;

    switch (s) {
    case SIGINT:
        c = "Interrupt s";
        break;
    case SIGQUIT:
        c = "Quit s";
        break;
    case SIGTERM:
        c = "Termination s";
        break;
    default:
        c = "S";
    }
    fprintf(stderr,"\nelcom: %signal received \n",c);
    exit(1);
} /* interrupt */

main (argc, argv)
int  argc;
char **argv;
{
    struct comliste *s;
    int             first, i, j, q;
    char            *c, n[85];

    if (signal(SIGINT,interrupt) == SIG_IGN)
        signal(SIGINT,SIG_IGN);
    if (signal(SIGQUIT,interrupt) == SIG_IGN)
        signal(SIGQUIT,SIG_IGN);
    if (signal(SIGTERM,interrupt) == SIG_IGN)
        signal(SIGTERM,SIG_IGN);
    if (signal(SIGUSR1,interrupt) == SIG_IGN)
        signal(SIGUSR1,SIG_IGN);
    if (signal(SIGUSR2,interrupt) == SIG_IGN)
        signal(SIGUSR2,SIG_IGN);
    first = q = 0;
    while (--argc > 0 && (*(++argv))[0] == '-')
        for (c = argv[0]+1; *c != '\0'; c++)
            switch (*c) {
            case 'q':  /* Keine Meldungen ausgeben  */
                q = 1;
                break;
            case 's':  /* Nach jeder Aktion stoppen */
                stop = 1;
                break;
            case 'v':  /* Alle Meldungen ausgeben   */
                msg = 2;
                break;
            default:
                if (!first) {
                    puts(aus1);
                    first = 1;
                }
                fprintf(stderr,"Unknown option: -%c \n", *c);
            }
    if (first) {    /* Falsche Optionen */
        putchar('\n');
        puts(aus2);
        exit(1);
    }
    if (q)
        msg = stop = 0;
    if (argc == 0) {   /* Kein Filename */
        puts(aus1);
        puts(aus3);
        puts(aus2);
        exit(1);
    }
    if (strlen(*argv) > 80) {
        puts(aus1);
        fputs("File name too long \n\n",stderr);
        exit(1);
    }
    strcpy(fname,*argv);
    i = strlen(fname) - 1;
    while (i >= 0 && fname[i] != '.' && fname[i] != '/')
        i--;
    if (i < 0 || fname[i] == '/')
        strcat(fname,".el");
    if ((f = fopen(fname,"r")) == NULL) {
        puts(aus1);
        fprintf(stderr,"Cannot open file \"%s\" \n\n",fname);
        exit(1);
    }
    if (msg)
        puts(aus1);
    strcpy(n,fname);
    i = strlen(n) - 1;
    while (i > 0 && n[i] != '.')
        i--;
    n[i] = '\0';
    strcpy(fbasis,n);
    while (i >= 0 && n[i] != '/')
        i--;
    i++;
    if (n[i] == '\0') {
        i = 0;
        strcpy(n,"noname");
    }
    if (msg) {
        printf("Compiling \"%s\" to G-code. \n\n", n+i);
        puts("PASS 1 -- Syntax analysis.");
    }
    if (analyse(f) != 0)
        exit(3);
    fclose(f);
    if (msg == 2 && stop)
        stop_print("");
    if (msg == 2 && !stop)
        putchar('\n');
    if (msg)
        puts("PASS 2 -- Scope analysis.");
    if (scope() != 0)
        exit(3);
    if (stop)
        stop_print("");
    /* Abhaengigkeitsanalyse: Hier einfuegen! */
    /* Typinferenz:           Hier einfuegen! */
    if (msg == 2 && !stop)
        putchar('\n');
    if (msg)
        puts("PASS 3 -- Application transformation.");
    prog = apptrans(prog,1);
    if (msg == 2)
        printf(aus4,"definitions");
    prog = elim(prog);
    if (msg == 2)
        puts("Computing binding levels.");
    neuniv(prog,0);
    if (stop)
        stop_print("");
    if (msg == 2 && !stop)
        putchar('\n');
    if (msg)
        puts("PASS 4 -- Lambda lifting.");
    lift(prog);
    if (msg == 2)
        printf(aus4,"let(rec)'s");
    s = comb;
    while (s!= NULL) {
        s->koerper = elim(s->koerper);
        s = s->next;
    }
    prog = elim(prog);
    if (stop)
        stop_print(msg == 2 ? "" :
            "after eliminating redundant let(rec)'s");
    /* Striktheitsanalyse:    Hier einfuegen! */
    if (msg == 2 && !stop)
        putchar('\n');
    if (msg)
        puts("PASS 5 -- G-code generation.");
    strcat(fbasis,".g");
    if (msg == 2) {
        if ((f = fopen(fbasis,"r")) != NULL) {
            fclose(f);
            c = "Rewriting";
        }
        else
            c = "Creating";
        printf("%s file \"%s\" \n\n",c,fbasis);
    }
    if ((f = fopen(fbasis,"w")) == NULL) {
        if (msg == 0)
            puts(aus1);
        fprintf(stderr,"Cannot open file \"%s\" \n\n",fbasis);
        exit(1);
    }
    codegen(n+i);
    fclose(f);
    if (msg)
        puts("\nCompilation terminated successfully! \n");
    exit(0);
} /* elcom */
