/* elcom.h -- Globale Definitionen fuer ELCOM */

#include <stdio.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>

/* Typliste: */

struct typliste {
    struct typliste  *next;
    int              zeile;       /* Beginn im Quelltext   */
    char             *typop;      /* Typformender Operator */
    int              konstanz;    /* Anzahl Konstruktoren  */
    int              schemanz;    /* Anzahl schemat. Var.  */
    struct prodliste *vars;       /* Schematische Variable */
    struct sumliste  *typen;      /* Zugeh. Summentypen    */
};

struct sumliste {
    struct sumliste  *next;
    int              begzeile;    /* Beginn im Quelltext   */
    char             *kons;       /* Konstruktorname       */
    int              stell;       /* Stelligkeit           */
    struct prodliste *prodtypen;  /* Produkttypen          */
};

struct prodliste {
    struct prodliste *next;
    char             *name;       /* Name Typ/schem. Var.  */
    int              nr;          /* Nr. der schem. Var.   */
    struct typliste  *typ;        /* Typ                   */
    struct prodliste *belegung;   /* Belegung d.schem.Var. */
};

/* Ausdruecke: */

struct ausdruck {
    int              art;         /* Ausdrucksart          */
    int              beginn;      /* Beginn im Quelltext   */
    /* Typ des Ausdrucks: Hier einfuegen. */
    int              strikt;      /* Nur bei Anwendungen   */
    struct defliste  *definition;
    int              stelligkeit;
    int              standardtyp; /* Bei Konstanten        */
    char             *wert;       /* Wert bei Konstante    */
    struct ausdruck  *links, *rechts, *hinten;
};

struct defliste {
    struct defliste  *next;
    char             *varname;    /* Variablenname         */
    int              defstrikt;   /* Fuer Abstraktionen    */
    struct hashtab   *sym;        /* Hash-Tabelleneintrag  */
    struct ausdruck  *varwert;    /* Variablenwert         */
    struct defliste  *abst;       /* Kurz:Abstrahiert.Var. */
};

/* Standardtypen: */

#define INTEGER  1
#define REAL     2
#define CHAR     3
#define VARNAME  4

/* Ausdrucksarten: */

#define KONST    1
#define VAR      2
#define ANW      3
#define LAMBDA   4
#define IF       5
#define CASE     6
#define MUSTER   7
#define FATBAR   8
#define FAIL     9
#define CONS    10
#define SELECT  11
#define LET     12
#define LETREC  13

/* Kombinatoren: */

struct comliste {
    struct comliste  *next;
    char             *comname;    /* Kombinatorname        */
    char             *altcom;     /* Alter Name            */
    struct defliste  *args;       /* Argumente             */
    int              anzargs;     /* Anzahl der Argumente  */
    struct defliste  *altargs;    /* Argumente vor Liften  */
    int              altanz;      /* Anzahl                */
    struct ausdruck  *koerper;    /* Lambda-Koerper        */
};

/* Hash-Tabelle: */

struct hashtab {
    struct hashtab   *next;
    char             *neuname;    /* Name nach Umbenennung */
    char             *altname;    /* Alter Name            */
    struct ausdruck  *def;        /* Wert                  */
    int              niveau;      /* De Bruijn-Nummer      */
};

/* Hash-Tabellengroesse: Kann einfach geaendert werden!: */

#define HASHSIZE 50

/* Primitive Funktionen aus el_prim.c: */

extern char *new(unsigned);

#define TYPLISTE  sizeof(struct typliste)
#define SUMLISTE  sizeof(struct sumliste)
#define PRODLISTE sizeof(struct prodliste)
#define AUSDRUCK  sizeof(struct ausdruck)
#define DEFLISTE  sizeof(struct defliste)
#define COMLISTE  sizeof(struct comliste)
#define HASHTAB   sizeof(struct hashtab)
