/* el_lift.c -- Pass:  Lambda-Lifting. */

#include "elcom.h"

extern int msg;                       /* elcom.c    */
extern int stop;                      /* elcom.c    */

extern struct comliste *comb;         /* elcom.c    */
extern struct comliste *last;         /* elcom.c    */

extern struct ausdruck *b_konst
(int, int, char *);                   /* el_syn.y   */
extern struct ausdruck *b_anw (int,
struct ausdruck *, struct ausdruck *);
extern struct defliste *b_def (char *,
struct ausdruck *);
extern struct defliste *app_def (struct defliste *,
struct defliste *);
extern char *newname (void);          /* el_names.c */
extern struct hashtab *lookup (char *);
extern struct hashtab *newentry (char *, char *,
struct ausdruck *, int);
extern int istkonst (char *);
extern stop_print (char *);           /* el_print.c */
extern subst (char *, char *,
struct ausdruck *);                   /* el_app.c   */

struct bindliste {
    struct bindliste *next;
    struct defliste  *def;
} *erster, *letzter;

neuniveau (d)
struct defliste *d;
{
    struct bindliste *b;

    /* Erzeuge Bindungsniveau fuer 'freivar' */
    b = (struct bindliste *)
        new(sizeof (struct bindliste));
    b->def = d;
    b->next = NULL;
    if (erster == NULL)
        erster = letzter = b;
    else {
        letzter->next = b;
        letzter = b;
    }
} /* neuniveau */

freiniveau ()
{
    struct bindliste *b, *bb;

    b = letzter;
    if (erster == letzter)
        erster = letzter = NULL;
    else {
        bb = erster;
        while (bb->next != letzter)
            bb = bb->next;
        bb->next = NULL;
        letzter = bb;
    }
    free(b);
} /* freiniveau */

struct defliste *fvar (frei, a)
struct defliste *frei;  /* Schon erkannte freie Var's */
struct ausdruck *a;
{
    struct bindliste *b;
    struct comliste  *s;
    struct defliste  *d, *t, *tt;
    struct ausdruck  *p;
    int              kom;
    char             *w;

    switch (a->art) {
    case KONST:
    case FAIL:
        return frei;
    case VAR:
        b = erster;
        d = NULL;
        while (b != NULL) {
            d = b->def;
            while (d != NULL && strcmp(d->varname,a->wert))
                d = d->next;
            if (d != NULL)
                break;
            b = b->next;
        }
        /* Kombinatoren werden nicht als freie */
        /* Variablen gemeldet.                 */
        kom = 0;
        if (d == NULL) {
            s = comb;
            while (s != NULL)
                if (!strcmp(s->comname,a->wert)) {
                    kom = 1;
                    break;
                }
                else
                    s = s->next;
        }
        if (d == NULL && !istkonst(a->wert) && !kom) {
            /* Freie Variable */
            w = new(strlen(a->wert)+1);
            strcpy(w,a->wert);
            t = b_def(w,NULL);
            t->defstrikt = (lookup(w))->niveau
                /* defstrikt: Niveau! */;
            if (frei == NULL)
                frei = t;
            else
                /* Einsortieren: Bind.niveaus aufsteigend */
                if (t->defstrikt < frei->defstrikt) {
                    t->next = frei;
                    frei = t;
                }
                else {
                    tt = frei;
                    while (tt->next != NULL &&
                        tt->next->defstrikt > t->defstrikt)
                        tt = tt->next;
                    t->next = tt->next;
                    tt->next = t;
                }
        }
        return frei;
    case ANW:
    case FATBAR:
        frei = fvar(frei,a->links);
        frei = fvar(frei,a->rechts);
        return frei;
    case IF:
    case CASE:
        frei = fvar(frei,a->links);
        p = a->rechts;
        while (p != NULL) {
            frei = fvar(frei,p);
            p = p->hinten;
        }
        return frei;
    case CONS:
        p = a->links;
        while (p != NULL) {
            frei = fvar(frei,p);
            p = p->hinten;
        }
        return frei;
    case SELECT:
        return fvar(frei,a->links);
    case MUSTER:
    case LAMBDA:
        neuniveau(a->definition);
        frei = fvar(frei,a->links);
        freiniveau();
        return frei;
    case LET:
        frei = fvar(frei,a->definition->varwert);
        neuniveau(a->definition);
        frei = fvar(frei,a->links);
        freiniveau();
        return frei;
    case LETREC:
        neuniveau(a->definition);
        d = a->definition;
        while (d != NULL) {
            frei = fvar(frei,d->varwert);
            d = d->next;
        }
        frei = fvar(frei,a->links);
        freiniveau();
        return frei;
    }
} /* fvar */

struct defliste *freivar (def, letrec, a)
struct defliste *def;         /* Definitionsliste */
struct defliste *letrec;
/* Im selben LETREC gebundene LAMBDA's.           */
struct ausdruck *a;
{
    struct defliste *frei;

    /* Bestimme die freien Variablen von "a". Ist */
    /* "a"  der  Ausdruck eines  LETREC's, werden */
    /* alle die im selben LETREC gebundenen Vari- */
    /* ablen nicht  als  frei  gemeldet,  die ein */
    /* LAMBDA zum Wert haben.                     */
    erster = letzter = NULL;
    neuniveau(def);
    neuniveau(letrec);
    /* Macht die eigentliche Arbeit: */
    frei = fvar(NULL,a);
    freiniveau();
    freiniveau();
    return frei;
} /* freivar */

struct defliste *umfrei (frei, a)
struct defliste *frei;
struct ausdruck *a;
{
    struct defliste *ab, *t, *tt;
    char            *neu, *neu1;

    /* Umbenennen der freien Variablen, damit sie */
    /* abstrahiert werden koennen.                */
    ab = NULL;
    while (frei != NULL) {
        neu = newname();
        neu1 = new(strlen(neu)+1);
        strcpy(neu1,neu);
        t = b_def(neu,NULL);
        t->sym = newentry(neu1,neu1,NULL,frei->defstrikt);
        subst(frei->varname,neu,a);
        if (ab == NULL)
            ab = t;
        else {
            tt = ab;
            while (tt->next != NULL)
                tt = tt->next;
            tt->next = t;
        }
        frei = frei->next;
    }
    return ab;
} /* umfrei */

struct ausdruck *anwendung (neu, frei)
char            *neu;
struct defliste *frei;
{
    struct ausdruck *l, *p, *var;
    char            *n, *n1;

    /* Konstruktion der Anwendung von  "neu"  auf */
    /* die freien Variablen (original) "frei".    */
    n = new(strlen(neu)+1);
    strcpy(n,neu);
    l = b_konst(VAR,VARNAME,n);
    while (frei != NULL) {
        n1 = new(strlen(frei->varname)+1);
        strcpy(n1,frei->varname);
        var = b_konst(VAR,VARNAME,n1);
        p = b_anw(ANW,l,var);
        l = p;
        frei = frei->next;
    }
    return l;
} /* anwendung */

freiabst (frei)
struct defliste *frei;
{
    struct defliste *d;

    while (frei != NULL) {
        d = frei;
        frei = frei->next;
        free(d);
    }
} /* freiabst */

ueberschreibe (a, p)
struct ausdruck *a, *p;
{
    a->art = p->art;
    a->strikt = 0;
    a->definition = NULL;
    a->stelligkeit = 0;
    a->standardtyp = p->standardtyp;
    a->wert = p->wert;
    a->links = p->links;
    a->rechts = p->rechts;
} /* ueberschreibe */

liftsubst (alt, neu, frei, a)
char            *alt, *neu;
struct defliste *frei;
struct ausdruck *a;
{
    struct ausdruck *p;
    struct defliste *d;

    /* Substituiert in "a" alle Vorkommen der Var */
    /* "alt" gegen (neu ...frei...).              */
    switch (a->art) {
    case KONST:
    case FAIL:
        return;
    case VAR:
        if (!strcmp(a->wert,alt)) {
            p = anwendung(neu,frei);
            ueberschreibe(a,p);
            free(p);
        }
        return;
    case ANW:
    case FATBAR:
        liftsubst(alt,neu,frei,a->links);
        liftsubst(alt,neu,frei,a->rechts);
        return;
    case LAMBDA:
    case MUSTER:
    case SELECT:
        liftsubst(alt,neu,frei,a->links);
        return;
    case IF:
    case CASE:
        liftsubst(alt,neu,frei,a->links);
        p = a->rechts;
        while (p != NULL) {
            liftsubst(alt,neu,frei,p);
            p = p->hinten;
        }
        return;
    case CONS:
        p = a->links;
        while (p != NULL) {
            liftsubst(alt,neu,frei,p);
            p = p->hinten;
        }
        return;
    case LET:
    case LETREC:
        d = a->definition;
        while (d != NULL) {
            liftsubst(alt,neu,frei,d->varwert);
            d = d->next;
        }
        liftsubst(alt,neu,frei,a->links);
        return;
    }
} /* liftsubst */

struct defliste *vorkommen (vor, ausser, lambdas, a)
struct defliste *vor;
char            *ausser;
struct defliste *lambdas;
struct ausdruck *a;
{
    struct ausdruck *p;
    struct defliste *d, *t, *tt;
    char            *neu;

    /* Gibt die Liste aller Var. aus  "a"  ausser */
    /* "ausser" zurueck, die in "lambdas" vorkom- */
    /* men.                                       */
    switch (a->art) {
    case KONST:
    case FAIL:
        return vor;
    case VAR:
        d = lambdas;
        while (d != NULL)
            if (!strcmp(d->varname,a->wert))
                if (strcmp(a->wert,ausser))
                    break;
                else
                    d = d->next;
            else
                d = d->next;
        if (d != NULL) {
            neu = new(strlen(a->wert)+1);
            strcpy(neu,a->wert);
            tt = b_def(neu,NULL);
            tt->abst = d->abst;
            if (vor == NULL)
                vor = tt;
            else {
                t = vor;
                while (t->next != NULL)
                    t = t->next;
                t->next = tt;
            }
        }
        return vor;
    case ANW:
    case FATBAR:
        vor = vorkommen(vor,ausser,lambdas,a->links);
        vor = vorkommen(vor,ausser,lambdas,a->rechts);
        return vor;
    case LAMBDA:
    case MUSTER:
    case SELECT:
        vor = vorkommen(vor,ausser,lambdas,a->links);
        return vor;
    case IF:
    case CASE:
        vor = vorkommen(vor,ausser,lambdas,a->links);
        p = a->rechts;
        while (p != NULL) {
            vor = vorkommen(vor,ausser,lambdas,p);
            p = p->hinten;
        }
        return vor;
    case CONS:
        p = a->links;
        while (p != NULL) {
            vor = vorkommen(vor,ausser,lambdas,p);
            p = p->hinten;
        }
        return vor;
    case LET:
    case LETREC:
        d = a->definition;
        while (d != NULL) {
            vor = vorkommen(vor,ausser,lambdas,d->varwert);
            d = d->next;
        }
        vor = vorkommen(vor,ausser,lambdas,a->links);
        return vor;
    }
} /* vorkommen */

struct defliste *vereinigung (a, b)
struct defliste *a, *b;
{
    struct defliste *t, *tt;
    char            *neu;

    /* a := a U b */
    if (a == NULL) {
        if (b == NULL)
            return NULL;
        neu = new(strlen(b->varname)+1);
        strcpy(neu,b->varname);
        a = b_def(neu,NULL);
        b = b->next;
    }
    while (b != NULL) {
        t = a;
        while (t != NULL && strcmp(t->varname,b->varname))
            t = t->next;
        if (t == NULL) {
            neu = new(strlen(b->varname)+1);
            strcpy(neu,b->varname);
            t = b_def(neu,NULL);
            t->defstrikt = b->defstrikt;
            if (t->defstrikt < a->defstrikt) {
                t->next = a;
                a = t;
            }
            else {
                tt = a;
                while (tt->next != NULL &&
                    tt->next->defstrikt > t->defstrikt)
                    tt = tt->next;
                t->next = tt->next;
                tt->next = t;
            }
        }
        b = b->next;
    }
    return a;
} /* vereinigung */

lift (a)
struct ausdruck *a;
{
    struct comliste *s, *neucomb, *neulast;
    struct ausdruck *p, *pp;
    struct defliste *d, *frei, *abstrahiert;
    struct defliste *vars, *lambdas, *t;
    int             i, iteration;
    char            *neu, *neu1, *str;

    switch (a->art) {
    case KONST:
    case VAR:
    case FAIL:
        return;
    case ANW:
    case FATBAR:
        lift(a->links);
        lift(a->rechts);
        return;
    case MUSTER:
    case SELECT:
        lift(a->links);
        return;
    case IF:
    case CASE:
        lift(a->links);
        p = a->rechts;
        while (p != NULL) {
            lift(p);
            p = p->hinten;
        }
        return;
    case CONS:
        p = a->links;
        while (p != NULL) {
            lift(p);
            p = p->hinten;
        }
        return;
    case LAMBDA:
        if (msg == 2) {
            printf("Lifting LAMBDA line %d: %d parameter",
                a->beginn,a->stelligkeit);
            if (a->stelligkeit != 1)
                putchar('s');
        }
        frei = freivar(a->definition,NULL,a->links);
        d = frei;
        i = 0;
        while (d != NULL) {
            i++;
            d = d->next;
        }
        if (msg == 2) {
            printf(", %d free variable",i);
            if (i != 1)
                putchar('s');
        }
        abstrahiert = umfrei(frei,a->links);
        /* Abstrahieren: */
        neu = newname();
        neu1 = new(strlen(neu)+1);
        strcpy(neu1,neu);
        newentry(neu1,neu1,NULL,0);
        s = (struct comliste *) new(COMLISTE);
        s->comname = s->altcom = neu;
        if (msg == 2)
            printf(". New name: \"%s\" \n",neu);
        if (abstrahiert == NULL)
            s->args = a->definition;
        else {
            d = abstrahiert;
            while (d->next != NULL)
                d = d->next;
            d->next = a->definition;
            s->args = abstrahiert;
        }
        s->anzargs = a->stelligkeit + i;
        s->altargs = a->definition;
        s->altanz = a->stelligkeit;
        s->koerper = a->links;
        s->next = NULL;
        if (comb == NULL)
            comb = last = s;
        else {
            last->next = s;
            last = s;
        }
        /* LAMBDA "a" ueberschreiben: */
        pp = anwendung(neu,frei);
        freiabst(frei);
        ueberschreibe(a,pp);
        free(pp);
        if (stop)
            stop_print(msg == 2 ? "" :
                "after lifting anonymous LAMBDA");
        /* Kombinator-Koerper liften: */
        lift(s->koerper);
        return;
    case LET:
        d = a->definition;
        p = d->varwert;
        if (p->art != LAMBDA) {
            lift(d->varwert);
            lift(a->links);
            return;
        }
        if (msg == 2) {
            printf("Lifting \"%s\" (LET line %d): ",
                d->sym->altname,p->beginn);
            printf("%d parameter",p->stelligkeit);
            if (p->stelligkeit != 1)
                putchar('s');
        }
        frei = freivar(p->definition,NULL,p->links);
        d = frei;
        i = 0;
        while (d != NULL) {
            i++;
            d = d->next;
        }
        if (msg == 2) {
            printf(", %d free variable",i);
            if (i != 1)
                putchar('s');
        }
        abstrahiert = umfrei(frei,p->links);
        /* Abstrahieren: */
        d = a->definition;
        neu = newname();
        neu1 = new(strlen(neu)+1);
        strcpy(neu1,neu);
        str = new(strlen(d->sym->altname)+1);
        strcpy(str,d->sym->altname);
        newentry(neu1,str,NULL,0);
        neu1 = new(strlen(d->sym->altname)+1);
        strcpy(neu1,d->sym->altname);
        s = (struct comliste *) new(COMLISTE);
        s->comname = neu;
        s->altcom = neu1;
        if (msg == 2)
            printf(". New name: \"%s\" \n",neu);
        if (abstrahiert == NULL)
            s->args = p->definition;
        else {
            d = abstrahiert;
            while (d->next != NULL)
                d = d->next;
            d->next = p->definition;
            s->args = abstrahiert;
        }
        s->anzargs = p->stelligkeit + i;
        s->altargs = p->definition;
        s->altanz = p->stelligkeit;
        s->koerper = p->links;
        s->next = NULL;
        if (comb == NULL)
            comb = last = s;
        else {
            last->next = s;
            last = s;
        }
        /* Vorkommen der gelifteten Variablen */
        /* ueberschreiben.                    */
        liftsubst(a->definition->varname,neu,frei,
            a->links);
        freiabst(frei);
        free(a->definition);
        a->definition = NULL;
        if (stop) {
            str = new(strlen(s->altcom)+25);
            strcpy(str,"after lifting \"");
            strcat(str,s->altcom);
            strcat(str,"\"");
            stop_print(msg == 2 ? "" : str);
            free(str);
        }
        /* Kombinator-Koerper liften: */
        lift(s->koerper);
        lift(a->links);
        return;
    case LETREC:
        /* Aufteilen der Definitionsliste in nor- */
        /* male  Var's und solche,  die  LAMBDA's */
        /* zum Wert haben.                        */
        vars = lambdas = NULL;
        d = a->definition;
        while (d != NULL) {
            frei = d;
            d = d->next;
            frei->next = NULL;
            if (frei->varwert->art == LAMBDA) {
                if (lambdas == NULL)
                    lambdas = frei;
                else {
                    t = lambdas;
                    while (t->next != NULL)
                        t = t->next;
                    t->next = frei;
                }
            }
            else {
                if (vars == NULL)
                    vars = frei;
                else {
                    t = vars;
                    while (t->next != NULL)
                        t = t->next;
                    t->next = frei;
                }
            }
        }
        a->definition = vars;
        if (lambdas == NULL) {    /* Nichts zum Liften! */
            d = a->definition;
            while (d != NULL) {
                lift(d->varwert);
                d = d->next;
            }
            lift(a->links);
            return;
        }
        d = lambdas;
        while (d != NULL) {    /* Freie Var's bestimmen */
            p = d->varwert;
            d->abst = freivar(p->definition,lambdas,
                p->links);
            d = d->next;
        }
        /* Kommen im Wert einer Variablen aus "lambdas" */
        /* andere Variablen  aus "lambdas" vor, muessen */
        /* deren abstrahierte Variablen zur  jeweiligen */
        /* Liste der  abstrahierten  Variablen im Sinne */
        /* der Mengenvereinigung hinzugefuegt werden.   */
        for (iteration = 1; iteration++ <= 2; ) {
            d = lambdas;
            while (d != NULL) {
                frei = vorkommen(NULL,d->varname,lambdas,
                    d->varwert->links);
                t = frei;
                while (t != NULL) {
                    d->abst = vereinigung(d->abst,t->abst);
                    t = t->next;
                }
                freiabst(frei);
                d = d->next;
            }
        }
        /* In allen LAMBDA's:  Substitution aller Var's */
        /* mit LAMBDA's zum Wert gegen (var ...abst...) */
        /* ACHTUNG! var & abst noch alt!                */
        d = lambdas;
        while (d != NULL) {
            t = lambdas;
            while (t != NULL) {
                liftsubst(t->varname,t->varname,t->abst,
                    d->varwert->links);
                t = t->next;
            }
            d = d->next;
        }
        /* Kombinatoren basteln: */
        neucomb = neulast = NULL;
        d = lambdas;
        while (d != NULL) {
            neu = newname();
            neu1 = new(strlen(neu)+1);
            strcpy(neu1,neu);
            str = new(strlen(d->sym->altname)+1);
            strcpy(str,d->sym->altname);
            newentry(neu1,str,NULL,0);
            s = (struct comliste *) new(COMLISTE);
            s->comname = neu;
            neu1 = new(strlen(d->sym->altname)+1);
            strcpy(neu1,d->sym->altname);
            s->altcom = neu1;
            i = 0;
            t = d->abst;
            while (t != NULL) {
                i++;
                t = t->next;
            }
            p = d->varwert;
            if (msg == 2) {
                printf("Lifting \"%s\" ",neu1);
                printf("(LETREC line %d): ",p->beginn);
                printf("%d parameter",p->stelligkeit);
                if (p->stelligkeit != 1)
                    putchar('s');
                printf(", %d free variable",i);
                if (i != 1)
                    putchar('s');
                printf(". New name: \"%s\" \n",neu);
            }
            s->args = umfrei(d->abst,p->links);
            if (s->args == NULL)
                s->args = p->definition;
            else {
                t = s->args;
                while (t->next != NULL)
                    t = t->next;
                t->next = p->definition;
            }
            s->anzargs = p->stelligkeit + i;
            s->altargs = p->definition;
            s->altanz = p->stelligkeit;
            s->koerper = p->links;
            s->next = NULL;
            if (neucomb == NULL)
                neucomb = neulast = s;
            else {
                neulast->next = s;
                neulast = s;
            }
            d = d->next;
        }
        /* Alle  gelifteten  Variablen  in  den */
        /* Kombinator-Koerpern substituieren:   */
        d = lambdas;
        while (d != NULL) {
            s = neucomb;
            t = lambdas;
            while (s != NULL) {
                subst(t->varname,s->comname,
                    d->varwert->links);
                s = s->next;
                t = t->next;
            }
            d = d->next;
        }
        /* Kombinatoren  an  "comb"  anhaengen: */
        if (comb == NULL)
            comb = neucomb;
        else
            last->next = neucomb;
        last = neulast;
        /* Substituieren in der  LETREC-Defini- */
        /* tionsliste und im Ausdruck:          */
        d = a->definition;
        while (d != NULL) {
            t = lambdas;
            s = neucomb;
            while (t != NULL) {
                liftsubst(t->varname,s->comname,
                    t->abst,d->varwert);
                t = t->next;
                s = s->next;
            }
            d = d->next;
        }
        t = lambdas;
        s = neucomb;
        while (t != NULL) {
            liftsubst(t->varname,s->comname,t->abst,
                a->links);
            freiabst(t->abst);
            free(t->varwert);
            t = t->next;
            s = s->next;
        }
        freiabst(lambdas);
        if (stop)
            stop_print(msg == 2 ? "" :
                "after lifting LETREC");
        /* Liften des restlichen LETREC's: */
        s = neucomb;
        while (s != NULL) {
            lift(s->koerper);
            s = s->next;
        }
        d = a->definition;
        while (d != NULL) {
            lift(d->varwert);
            d = d->next;
        }
        lift(a->links);
        return;
    }
} /* lift */
