/* el_names.c -- Funktionen fuer Namensbehandlung */

#include "elcom.h"

extern struct hashtab *hash[HASHSIZE]; /* elcom.c */

long beznummer;

int sfunc[20] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

char *konstanten[] = {
    "not", "neg", "add", "sub", "mult", "div", "mod",
    "and", "or", "lt", "leq", "eq", "neq", "geq", "gt",
    "ord", "chr", "seq", "read", "##"
};

char *newname ()
{
    int  i;
    long n;
    char *c;

    i = 3;
    n = beznummer;
    while ((n /= 10) > 0)
        i++;
    c = new(i);
    sprintf(c,"i%ld",beznummer++);
    return c;
} /* newname */

int hashfun (c)
char *c;
{
    int i;

    i = 1;
    while (*c != '\0') {
        i *= *(c++);
        if (i > 10000)
            i -= 10000;
        i++;
    }
    return abs(i) % (HASHSIZE - 1);
} /* hashfun */

struct hashtab *lookup (c)
char *c;
{
    struct hashtab *h;

    h = hash[hashfun(c)];
    while (h != NULL && strcmp(c,h->neuname))
        h = h->next;
    return h;
} /* lookup */

struct hashtab *newentry (n, a, d, niv)
char            *n, *a;
struct ausdruck *d;
int             niv;
{
    struct hashtab *h, *p;
    int            i;

    p = (struct hashtab *) new(HASHTAB);
    p->neuname = n;
    p->altname = a;
    p->def = d;
    p->niveau = niv;
    i = hashfun(n);
    h = hash[i];
    hash[i] = p;
    p->next = h;
    return p;
} /* newentry */

int istkonst (c)
char *c;
{
    int  i;
    char **k;

    i = 0;
    k = konstanten;
    while (strcmp(*k,"##") && strcmp(*k,c)) {
        i++;
        k++;
    }
    if (!strcmp(*k,c)) {
        sfunc[i] = 1;
        return 1;
    }
    return 0;
} /* istkonst */

freehash (c)
char *c;
{
    struct hashtab *h, *hh;
    int            i;

    i = hashfun(c);
    h = hash[i];
    if (!strcmp((hash[i])->neuname,c))
        hash[i] = h->next;
    else {
        while (strcmp(h->next->neuname,c))
            h = h->next;
        hh = h->next;
        h->next = h->next->next;
        h = hh;
    }
    free(h);
} /* freehash */
