/* el_print.c -- Stoppen und Syntaxbaum ausgeben */

#include "elcom.h"

extern int msg;                            /* elcom.c */

extern struct typliste *defs;              /* elcom.c */
extern struct ausdruck *prog;              /* elcom.c */
extern struct comliste *comb;              /* elcom.c */
extern struct hashtab  *hash[HASHSIZE];    /* elcom.c */

extern struct hashtab *lookup (char *); /* el_names.c */

char *vor (zeile)
char *zeile;
{
    while (*zeile == ' ' || *zeile == '\t')
        zeile++;
    return zeile;
} /* vor */

char *lese (zeile, w)
char *zeile, *w;
{
    int i;

    zeile = vor(zeile);
    i = 1;
    while (!isspace(*zeile) && i++ < 20)
        *(w++) = *(zeile++);
    *w = '\0';
    return zeile;
} /* lese */

stop_print (m)
char *m;
{
    struct hashtab *h;
    FILE           *dest;
    int            i, neu, zaehler;
    char           zeile[150], w[25], *c, *cc;

    printf("\nStopped %s \n",m);
    puts("Type <return> to continue, '?' for help.");
    for (;;) {
        printf("> ");
        zaehler = 0;
        while (fgets(zeile,150,stdin) == NULL) {
            fputs("Use \"exit\" to leave ELCOM!",stderr);
            printf("\n> ");
            zaehler++;
            if (zaehler >= 6) {
                puts("\n");
                exit(3);
            }
        }
        c = lese(zeile,w);
        if (*w == '\0') {
            putchar('\n');
            return;
        }
        else if (!strcmp(w,"exit")) {
            puts("You have buried ELCOM! \n");
            exit(3);
        }
        else if (!strcmp(w,"?")) {
            puts("     print      [ new ] [ > file ]");
            puts("     print      type");
            puts("     print      combinators [ new ]");
            puts("     print      expr [ new ]");
            puts("     hashtable");
        }
        else if (!strcmp(w,"print") || !strcmp(w,"p")) {
            dest = stdout;
            c = lese(c,w);
            if (*w == '>') {
                c -= strlen(w);
                *w = '\0';
            }
            if (*w == '\0' || !strcmp(w,"new")) {
                neu = !strcmp(w,"new");
                c = lese(c,w);
                if (*w == '>') {
                    cc = w;
                    do {
                        *cc = *(cc+1);
                        cc++;
                    } while (*(cc-1) != '\0');
                    if (!isalnum(*w))
                        c = lese(c,w);
                    if ((dest = fopen(w,"r")) != NULL) {
                        /* Vorsicht ist die Mutter... */
                        fclose(dest);
                        fputs("File \"",stderr);
                        fputs(w,stderr);
                        fputs("\" already exists \n",stderr);
                        continue;
                    }
                    if ((dest = fopen(w,"w")) == NULL) {
                        fputs("Cannot open file \"",stderr);
                        fputs(w,stderr);
                        fputs("\" \n",stderr);
                        continue;
                    }
                }
                aus_typ(defs,dest);
                aus_com(comb,dest,neu);
                aus_aus(prog,dest,1,neu);
            }
            else if (!strcmp(w,"type"))
                aus_typ(defs,stdout);
            else if (!strcmp(w,"combinators") ||
                !strcmp(w,"comb")) {
                c = lese(c,w);
                neu = !strcmp(w,"new");
                aus_com(comb,stdout,neu);
            }
            else if (!strcmp(w,"expr")) {
                c = lese(c,w);
                neu = !strcmp(w,"new");
                aus_aus(prog,stdout,1,neu);
            }
            else
                printf("Unknown argument: %s \n",w);
            if (dest != stdout)
                fclose(dest);
        }
        else if (!strcmp(w,"hashtable") ||
            !strcmp(w,"h")) {
            i = HASHSIZE;
            zaehler = 0;
            printf("Hash table has %d indexes.",i);
            for (i = 0; i < HASHSIZE; i++)
                if (hash[i] != NULL) {
                    printf("\nIndex %2d:",i);
                    h = hash[i];
                    while (h != NULL) {
                        printf(" %s[",h->neuname);
                        if (!strcmp(h->altname,h->neuname))
                            printf("--");
                        else
                            printf(h->altname);
                        printf(",%d",h->niveau);
                        putchar(']');
                        h = h->next;
                    }
                    zaehler = 1;
                }
            if (zaehler)
                putchar('\n');
            else
                puts(" Table is empty.");
        }
        else
            printf("Unknown command: %s \n",w);
    }
} /* stop_print */

int ez;

writeln (f)
FILE *f;
{
    int i;

    putc('\n',f);
    for (i = 1; i++ <= ez; )
        putc(' ',f);
} /* writeln */

aus_typ(p, f)
struct typliste *p;
FILE            *f;
{
    if (p == NULL)
        return;
    ez = 0;
    fputs("type ",f);
    ez = 5;
    while (p != NULL) {
        fputs(p->typop,f);
        aus_schemvars(p->vars,f);
        ez += 4;
        writeln(f);
        fputs("= ",f);
        aus_summen(p->typen,f);
        ez -= 4;
        if (p->next != NULL)
            putc(';',f);
        else
            ez = 0;
        writeln(f);
        p = p->next;
    }
    fputs("end \n\n",f);
} /* aus_typ */

aus_schemvars (p, f)
struct prodliste *p;
FILE             *f;
{
    int i;

    i = 1;
    while (p != NULL) {
        if (i++ % 10 == 0)
            writeln(f);
        else
            putc(' ',f);
        fputs(p->name,f);
        p = p->next;
    }
} /* aus_schemvars */

aus_summen (p, f)
struct sumliste *p;
FILE            *f;
{
    while (p != NULL) {
        fputs(p->kons,f);
        ez += 2;
        aus_prod(p->prodtypen,f);
        ez -= 2;
        p = p->next;
        if (p != NULL) {
            writeln(f);
            fputs("| ",f);
        }
    }
} /* aus_summen */

aus_prod (p, f)
struct prodliste *p;
FILE             *f;
{
    while (p != NULL) {
        putc(' ',f);
        if (p->belegung != NULL)
            putc('(',f);
        fputs(p->name,f);
        aus_schemvars(p->belegung,f);
        if (p->belegung != NULL)
            putc(')',f);
        p = p->next;
    }
} /* aus_prod */

aus_com (p, f, neu)
struct comliste *p;
FILE            *f;
int             neu;
{
    if (p == NULL)
        return;
    ez = 0;
    fputs("combinators",f);
    ez = 4;
    while (p != NULL) {
        writeln(f);
        if (neu) {
            fprintf(f,"%s[",p->comname);
            if (!strcmp(p->comname,p->altcom))
                fputs("--",f);
            else
                fputs(p->altcom,f);
            putc(']',f);
        }
        else
            fputs(p->altcom,f);
        aus_defs(p->args,f,neu);
        fputs(" = ",f);
        ez += 4;
        aus_aus(p->koerper,f,0,neu);
        ez -= 4;
        p = p->next;
        if (p != NULL)
            putc(';',f);
    }
    ez = 0;
    writeln(f);
    fputs("end \n\n",f);
} /* aus_com */

aus_aus (p, f, links, neu)
struct ausdruck *p;
FILE            *f;
int             links, neu;
{
    struct hashtab *h;
    int            ezret;

    if (links)
        ez = 0;
    switch (p->art) {
    case KONST:
        fputs(p->wert,f);
        break;
    case VAR:
        h = lookup(p->wert);
        if (h == NULL) {
            fputs(p->wert,f);
            break;
        }
        if (neu)
            fprintf(f,"%s[",p->wert);
        if (neu && !strcmp(h->altname,h->neuname))
            fputs("--",f);
        else
            fputs(h->altname,f);
        if (neu)
            putc(']',f);
        break;
    case FAIL:
        fputs("fail",f);
        break;
    case FATBAR:
        fputs("fatbar",f);
    case ANW:
        putc('(',f);
        ez++;
        aus_aus(p->links,f,0,neu);
        putc(' ',f);
        ez += 5;
        aus_aus(p->rechts,f,0,neu);
        ez -= 6;
        putc(')',f);
        break;
    case LAMBDA:
        fputs("lambda",f);
        ez += 7;
        aus_defs(p->definition,f,neu);
        fputs(". ",f);
        ez += 5;
        aus_aus(p->links,f,0,neu);
        ez -= 12;
        fputs(" end",f);
        break;
    case IF:
        fputs("if ",f);
        aus_aus(p->links,f,0,neu);
        ez += 3;
        writeln(f);
        fputs("then ",f);
        ez += 5;
        aus_aus(p->rechts,f,0,neu);
        ez -= 5;
        writeln(f);
        fputs("else ",f);
        ez += 5;
        aus_aus(p->rechts->hinten,f,0,neu);
        ez -= 8;
        writeln(f);
        fputs("end",f);
        break;
    case CASE:
        fputs("case ",f);
        ez += 5;
        aus_aus(p->links,f,0,neu);
        ez -= 2;
        fputs(" of",f);
        writeln(f);
        aus_al(p->rechts,f,neu);
        ez -= 3;
        writeln(f);
        fputs("end",f);
        break;
    case MUSTER:
        fputs(p->wert,f);
        ez += 3;
        aus_defs(p->definition,f,neu);
        fputs(" => ",f);
        ez += 3;
        aus_aus(p->links,f,0,neu);
        ez -= 6;
        if (p->hinten != NULL) {
            putc(';',f);
            writeln(f);
        }
        break;
    case CONS:
        fputs("construct(",f);
        fputs(p->wert,f);
        if (p->links != NULL)
            fputs(", ",f);
        ezret = ez;
        ez += strlen(p->wert) + 12;
        aus_al(p->links,f,neu);
        ez = ezret;
        putc(')',f);
        break;
    case SELECT:
        fprintf(f,"select(%s, ",p->wert);
        ezret = ez;
        ez += strlen(p->wert) + 9;
        aus_aus(p->links,f,0,neu);
        ez = ezret;
        putc(')',f);
        break;
    case LET:
    case LETREC:
        fputs("let",f);
        if (p->art == LETREC)
            fputs("rec",f);
        ez += 4;
        writeln(f);
        aus_defs(p->definition,f,neu);
        ez -= 4;
        writeln(f);
        fputs("in ",f);
        ez += 4;
        aus_aus(p->links,f,0,neu);
        ez -= 4;
        writeln(f);
        fputs("end",f);
    }
    if (links)
        fputs("\n\n",f);
} /* aus_aus */

aus_defs (p, f, neu)
struct defliste *p;
FILE            *f;
int             neu;
{
    while (p != NULL) {
        putc(' ',f);
        if (p->sym == NULL)
            fputs(p->varname,f);
        else {
            if (neu)
                fprintf(f,"%s[",p->varname);
            if (neu && !strcmp(p->sym->altname,
                p->sym->neuname))
                fputs("--",f);
            else
                fputs(p->sym->altname,f);
            if (neu)
                putc(']',f);
        }
        if (p->varwert != NULL) {
            fputs(" = ",f);
            ez += 4;
            aus_aus(p->varwert,f,0,neu);
            ez -= 4;
            if (p->next != NULL) {
                putc(';',f);
                writeln(f);
            }
        }
        p = p->next;
    }
} /* aus_defs */

aus_al (p, f, neu)
struct ausdruck *p;
FILE            *f;
int             neu;
{
    while (p != NULL) {
        aus_aus(p,f,0,neu);
        if (p->art != MUSTER && p->hinten != NULL)
            fputs(", ",f);
        p = p->hinten;
    }
} /* aus_al */
