/* el_scope.c -- Pass:  Gueltigkeitsbereich-Analyse */

#include "elcom.h"

extern int  msg;                        /* elcom.c */
extern char fname[85];                  /* elcom.c */
extern long beznummer;               /* el_names.c */

extern struct typliste *defs;           /* elcom.c */
extern struct ausdruck *prog;           /* elcom.c */
extern struct hashtab  *hash[HASHSIZE]; /* elcom.c */

extern char *newname(void);          /* el_names.c */
extern struct hashtab *lookup(char *);
extern struct hashtab *newentry(char *, char *,
struct ausdruck *, int);
extern int istkonst(char *);

struct bindliste {
    struct bindliste *next;
    struct bindliste *prev;
    struct defliste  *def;
} *erster, *letzter;

neubind (d, niv, art, zeilennr)
struct defliste *d;
int             niv, art, zeilennr;
{
    struct bindliste *b;
    char             *neu;

    /* Erzeuge neues Bindungsniveau-Listenelement. */
    b = (struct bindliste *) new(sizeof(struct bindliste));
    b->def = d;
    b->next = NULL;
    if (erster == NULL) {
        erster = letzter = b;
        b->prev = NULL;
    }
    else {
        letzter->next = b;
        b->prev = letzter;
        letzter = b;
    }
    if (msg == 2) {
        switch (art) {
        case LAMBDA:
            printf("LAMBDA");
            break;
        case MUSTER:
            printf("PATTERN IN CASE");
            break;
        case LET:
            printf("LET");
            break;
        case LETREC:
            printf("LETREC");
        }
        printf(" line %d, level %d ... \n",zeilennr,niv);
    }
    while (d != NULL) {
        neu = newname();
        if (msg == 2)
            printf("... Renaming \"%s\" to \"%s\" \n",
                d->varname,neu);
        d->sym = newentry(neu,d->varname,d->varwert,niv);
        d->varname = new(strlen(neu)+1);
        strcpy(d->varname,neu);
        d = d->next;
    }
} /* neubind */

freibind ()
{
    struct bindliste *b;

    b = letzter;
    if (erster == letzter)
        erster = letzter = NULL;
    else {
        letzter = letzter->prev;
        letzter->next = NULL;
    }
    free(b);
} /* freibind */

int umbenennen (a, niv)
struct ausdruck *a;
int             niv;
{
    struct bindliste *b;
    struct ausdruck  *p;
    struct defliste  *d;
    int              i;

    switch (a->art) {
    case KONST:
    case FAIL:
        return 0;
    case VAR:
        b = letzter;
        d = NULL;
        while (b != NULL) {
            d = b->def;
            while (d != NULL && strcmp(a->wert,d->sym->altname))
                d = d->next;
            if (d != NULL)
                break;
            b = b->prev;
        }
        if (d != NULL) {
            free(a->wert);
            a->wert = new(strlen(d->varname)+1);
            strcpy(a->wert,d->varname);
            return 0;
        }
        if (istkonst(a->wert))
            return 0;
        fprintf(stderr,"\"%s\" line %d: ",fname,a->beginn);
        fprintf(stderr,"Unbound variable: \"%s\" \n",
            a->wert);
        return 1;
    case ANW:
    case FATBAR:
        return umbenennen(a->links,niv) +
            umbenennen(a->rechts,niv);
    case IF:
    case CASE:
        i = umbenennen(a->links,niv);
        p = a->rechts;
        while (p != NULL) {
            i += umbenennen(p,niv);
            p = p->hinten;
        }
        return i ? 1 : 0;
    case CONS:
        i = 0;
        p = a->links;
        while (p != NULL) {
            i += umbenennen(p,niv);
            p = p->hinten;
        }
        return i ? 1 : 0;
    case SELECT:
        return umbenennen(a->links,niv);
    case MUSTER:
    case LAMBDA:
        neubind(a->definition,niv,a->art,a->beginn);
        i = umbenennen(a->links,niv+1);
        freibind();
        return i;
    case LET:
        i = umbenennen(a->definition->varwert,niv);
        neubind(a->definition,niv,a->art,a->beginn);
        i += umbenennen(a->links,niv+1);
        freibind();
        return i ? 1 : 0;
    case LETREC:
        neubind(a->definition,niv,a->art,a->beginn);
        i = 0;
        d = a->definition;
        while (d != NULL) {
            i += umbenennen(d->varwert,niv+1);
            if (d->varwert->art == VAR &&
                !strcmp(d->varname,d->varwert->wert)) {
                fprintf(stderr,"\"%s\" line %d: ",
                    fname,d->varwert->beginn);
                fprintf(stderr,"\"Letrec %s = %s;\" ",
                    d->sym->altname,d->sym->altname);
                fputs("not allowed (sensless)\n",stderr);
                i = 1;
            }
            d = d->next;
        }
        i += umbenennen(a->links,niv+1);
        freibind();
        return i ? 1 : 0;
    }
} /* umbenennen */

scope ()
{
    int i;

    erster = letzter = NULL;
    beznummer = 1;
    for (i = 0; i < HASHSIZE; )
        hash[i++] = NULL;
    return umbenennen(prog,0);
} /* scope */
